// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Versioning information for a sub-artifact of the current snapshot artifact.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class SnapshotVersion
    implements Serializable
{
    /**
     * The classifier of the sub-artifact. Each classifier and extension pair may only appear once.
     */
    final String classifier;
    /**
     * The file extension of the sub-artifact. Each classifier and extension pair may only appear once.
     */
    final String extension;
    /**
     * The resolved snapshot version of the sub-artifact.
     */
    final String version;
    /**
     * The timestamp when this version information was last updated. The timestamp is expressed using UTC in the format yyyyMMddHHmmss.
     */
    final String updated;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    SnapshotVersion(
        String classifier,
        String extension,
        String version,
        String updated
    ) {
        this.classifier = classifier;
        this.extension = extension;
        this.version = version;
        this.updated = updated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SnapshotVersion)) {
            return false;
        }
        SnapshotVersion that = (SnapshotVersion) o;
        return Objects.equals( this.classifier, that.classifier ) && Objects.equals( this.extension, that.extension ) && Objects.equals( this.version, that.version ) && Objects.equals( this.updated, that.updated );
    }

    @Override
    public int hashCode() {
        return Objects.hash(classifier, this.extension, this.version, this.updated);
    }

    /**
     * The classifier of the sub-artifact. Each classifier and extension pair may only appear once.
     *
     * @return a {@code String}
     */
    public String getClassifier() {
        return this.classifier;
    }

    /**
     * The file extension of the sub-artifact. Each classifier and extension pair may only appear once.
     *
     * @return a {@code String}
     */
    public String getExtension() {
        return this.extension;
    }

    /**
     * The resolved snapshot version of the sub-artifact.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * The timestamp when this version information was last updated. The timestamp is expressed using UTC in the format yyyyMMddHHmmss.
     *
     * @return a {@code String}
     */
    public String getUpdated() {
        return this.updated;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code SnapshotVersion} instance using the specified classifier.
     *
     * @param classifier the new {@code String} to use
     * @return a {@code SnapshotVersion} with the specified classifier
     */
    @Nonnull
    public SnapshotVersion withClassifier(String classifier) {
        return newBuilder(this, true).classifier(classifier).build();
    }
    /**
     * Creates a new {@code SnapshotVersion} instance using the specified extension.
     *
     * @param extension the new {@code String} to use
     * @return a {@code SnapshotVersion} with the specified extension
     */
    @Nonnull
    public SnapshotVersion withExtension(String extension) {
        return newBuilder(this, true).extension(extension).build();
    }
    /**
     * Creates a new {@code SnapshotVersion} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code SnapshotVersion} with the specified version
     */
    @Nonnull
    public SnapshotVersion withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code SnapshotVersion} instance using the specified updated.
     *
     * @param updated the new {@code String} to use
     * @return a {@code SnapshotVersion} with the specified updated
     */
    @Nonnull
    public SnapshotVersion withUpdated(String updated) {
        return newBuilder(this, true).updated(updated).build();
    }

    /**
     * Creates a new {@code SnapshotVersion} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code SnapshotVersion}
     */
    @Nonnull
    public static SnapshotVersion newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code SnapshotVersion} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code SnapshotVersion}
     */
    @Nonnull
    public static SnapshotVersion newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code SnapshotVersion} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code SnapshotVersion} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code SnapshotVersion} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code SnapshotVersion} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(SnapshotVersion from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code SnapshotVersion} builder instance using the specified object as a basis.
     *
     * @param from the {@code SnapshotVersion} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(SnapshotVersion from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create SnapshotVersion instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        SnapshotVersion base;
        String classifier;
        String extension;
        String version;
        String updated;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(SnapshotVersion base, boolean forceCopy) {
            if (forceCopy) {
                this.classifier = base.classifier;
                this.extension = base.extension;
                this.version = base.version;
                this.updated = base.updated;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Nonnull
        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder updated(String updated) {
            this.updated = updated;
            return this;
        }


        @Nonnull
        public SnapshotVersion build() {
            if (base != null
                    && (classifier == null || classifier == base.classifier)
                    && (extension == null || extension == base.extension)
                    && (version == null || version == base.version)
                    && (updated == null || updated == base.updated)
            ) {
                return base;
            }
            return new SnapshotVersion(
                classifier != null ? classifier : (base != null ? base.classifier : null),
                extension != null ? extension : (base != null ? base.extension : null),
                version != null ? version : (base != null ? base.version : null),
                updated != null ? updated : (base != null ? base.updated : null)
            );
        }
    }

}
