// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Versioning information for "groupId/artifactId" or "groupId/artifactId/version" SNAPSHOT
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Versioning
    implements Serializable
{
    /**
     * What the last version added to the directory is, including both releases and snapshots ("groupId/artifactId" directory only)
     */
    final String latest;
    /**
     * What the last version added to the directory is, for the releases only ("groupId/artifactId" directory only)
     */
    final String release;
    /**
     * Versions available of the artifact (both releases and snapshots) ("groupId/artifactId" directory only)
     */
    final List<String> versions;
    /**
     * When the metadata was last updated (both "groupId/artifactId" and "groupId/artifactId/version" directories). The timestamp is expressed using UTC in the format yyyyMMddHHmmss.
     */
    final String lastUpdated;
    /**
     * The current snapshot data in use for this version ("groupId/artifactId/version" only)
     */
    final Snapshot snapshot;
    /**
     * Information for each sub-artifact available in this artifact snapshot. This is only the most recent SNAPSHOT for each unique extension/classifier combination.
     */
    final List<SnapshotVersion> snapshotVersions;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Versioning(
        String latest,
        String release,
        Collection<String> versions,
        String lastUpdated,
        Snapshot snapshot,
        Collection<SnapshotVersion> snapshotVersions
    ) {
        this.latest = latest;
        this.release = release;
        this.versions = ImmutableCollections.copy(versions);
        this.lastUpdated = lastUpdated;
        this.snapshot = snapshot;
        this.snapshotVersions = ImmutableCollections.copy(snapshotVersions);
    }

    /**
     * What the last version added to the directory is, including both releases and snapshots ("groupId/artifactId" directory only)
     *
     * @return a {@code String}
     */
    public String getLatest() {
        return this.latest;
    }

    /**
     * What the last version added to the directory is, for the releases only ("groupId/artifactId" directory only)
     *
     * @return a {@code String}
     */
    public String getRelease() {
        return this.release;
    }

    /**
     * Versions available of the artifact (both releases and snapshots) ("groupId/artifactId" directory only)
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getVersions() {
        return this.versions;
    }

    /**
     * When the metadata was last updated (both "groupId/artifactId" and "groupId/artifactId/version" directories). The timestamp is expressed using UTC in the format yyyyMMddHHmmss.
     *
     * @return a {@code String}
     */
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    /**
     * The current snapshot data in use for this version ("groupId/artifactId/version" only)
     *
     * @return a {@code Snapshot}
     */
    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    /**
     * Information for each sub-artifact available in this artifact snapshot. This is only the most recent SNAPSHOT for each unique extension/classifier combination.
     *
     * @return a {@code List<SnapshotVersion>}
     */
    @Nonnull
    public List<SnapshotVersion> getSnapshotVersions() {
        return this.snapshotVersions;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Versioning} instance using the specified latest.
     *
     * @param latest the new {@code String} to use
     * @return a {@code Versioning} with the specified latest
     */
    @Nonnull
    public Versioning withLatest(String latest) {
        return newBuilder(this, true).latest(latest).build();
    }
    /**
     * Creates a new {@code Versioning} instance using the specified release.
     *
     * @param release the new {@code String} to use
     * @return a {@code Versioning} with the specified release
     */
    @Nonnull
    public Versioning withRelease(String release) {
        return newBuilder(this, true).release(release).build();
    }
    /**
     * Creates a new {@code Versioning} instance using the specified versions.
     *
     * @param versions the new {@code Collection<String>} to use
     * @return a {@code Versioning} with the specified versions
     */
    @Nonnull
    public Versioning withVersions(Collection<String> versions) {
        return newBuilder(this, true).versions(versions).build();
    }
    /**
     * Creates a new {@code Versioning} instance using the specified lastUpdated.
     *
     * @param lastUpdated the new {@code String} to use
     * @return a {@code Versioning} with the specified lastUpdated
     */
    @Nonnull
    public Versioning withLastUpdated(String lastUpdated) {
        return newBuilder(this, true).lastUpdated(lastUpdated).build();
    }
    /**
     * Creates a new {@code Versioning} instance using the specified snapshot.
     *
     * @param snapshot the new {@code Snapshot} to use
     * @return a {@code Versioning} with the specified snapshot
     */
    @Nonnull
    public Versioning withSnapshot(Snapshot snapshot) {
        return newBuilder(this, true).snapshot(snapshot).build();
    }
    /**
     * Creates a new {@code Versioning} instance using the specified snapshotVersions.
     *
     * @param snapshotVersions the new {@code Collection<SnapshotVersion>} to use
     * @return a {@code Versioning} with the specified snapshotVersions
     */
    @Nonnull
    public Versioning withSnapshotVersions(Collection<SnapshotVersion> snapshotVersions) {
        return newBuilder(this, true).snapshotVersions(snapshotVersions).build();
    }

    /**
     * Creates a new {@code Versioning} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Versioning}
     */
    @Nonnull
    public static Versioning newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Versioning} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Versioning}
     */
    @Nonnull
    public static Versioning newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Versioning} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Versioning} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Versioning} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Versioning} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Versioning from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Versioning} builder instance using the specified object as a basis.
     *
     * @param from the {@code Versioning} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Versioning from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Versioning instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Versioning base;
        String latest;
        String release;
        Collection<String> versions;
        String lastUpdated;
        Snapshot snapshot;
        Collection<SnapshotVersion> snapshotVersions;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(Versioning base, boolean forceCopy) {
            if (forceCopy) {
                this.latest = base.latest;
                this.release = base.release;
                this.versions = base.versions;
                this.lastUpdated = base.lastUpdated;
                this.snapshot = base.snapshot;
                this.snapshotVersions = base.snapshotVersions;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder latest(String latest) {
            this.latest = latest;
            return this;
        }

        @Nonnull
        public Builder release(String release) {
            this.release = release;
            return this;
        }

        @Nonnull
        public Builder versions(Collection<String> versions) {
            this.versions = versions;
            return this;
        }

        @Nonnull
        public Builder lastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Nonnull
        public Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @Nonnull
        public Builder snapshotVersions(Collection<SnapshotVersion> snapshotVersions) {
            this.snapshotVersions = snapshotVersions;
            return this;
        }


        @Nonnull
        public Versioning build() {
            if (base != null
                    && (latest == null || latest == base.latest)
                    && (release == null || release == base.release)
                    && (versions == null || versions == base.versions)
                    && (lastUpdated == null || lastUpdated == base.lastUpdated)
                    && (snapshot == null || snapshot == base.snapshot)
                    && (snapshotVersions == null || snapshotVersions == base.snapshotVersions)
            ) {
                return base;
            }
            return new Versioning(
                latest != null ? latest : (base != null ? base.latest : null),
                release != null ? release : (base != null ? base.release : null),
                versions != null ? versions : (base != null ? base.versions : null),
                lastUpdated != null ? lastUpdated : (base != null ? base.lastUpdated : null),
                snapshot != null ? snapshot : (base != null ? base.snapshot : null),
                snapshotVersions != null ? snapshotVersions : (base != null ? base.snapshotVersions : null)
            );
        }
    }

}
