/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PatternSet
implements Serializable,
InputLocationTracker {
    final List<String> includes;
    final List<String> excludes;
    final InputLocation location;
    final InputLocation includesLocation;
    final InputLocation excludesLocation;
    final Map<Object, InputLocation> locations;

    PatternSet(Collection<String> includes, Collection<String> excludes, Map<Object, InputLocation> locations, InputLocation location, InputLocation includesLocation, InputLocation excludesLocation) {
        this.includes = ImmutableCollections.copy(includes);
        this.excludes = ImmutableCollections.copy(excludes);
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.includesLocation = includesLocation;
        this.excludesLocation = excludesLocation;
    }

    @Nonnull
    public List<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "includes": {
                    return this.includesLocation;
                }
                case "excludes": {
                    return this.excludesLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return PatternSet.newBuilder(this);
    }

    @Nonnull
    public PatternSet withIncludes(Collection<String> includes) {
        return this.with().includes(includes).build();
    }

    @Nonnull
    public PatternSet withExcludes(Collection<String> excludes) {
        return this.with().excludes(excludes).build();
    }

    @Nonnull
    public static PatternSet newInstance() {
        return PatternSet.newInstance(true);
    }

    @Nonnull
    public static PatternSet newInstance(boolean withDefaults) {
        return PatternSet.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PatternSet.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PatternSet from) {
        return PatternSet.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PatternSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PatternSet [includes: {");
        for (String str : this.getIncludes()) {
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}, excludes: {");
        for (String str : this.getExcludes()) {
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}]");
        return sb.toString();
    }

    @NotThreadSafe
    public static class Builder {
        PatternSet base;
        Collection<String> includes;
        Collection<String> excludes;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PatternSet base, boolean forceCopy) {
            if (forceCopy) {
                this.includes = base.includes;
                this.excludes = base.excludes;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PatternSet build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation includesLocation = null;
            InputLocation excludesLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                includesLocation = locations.remove("includes");
                excludesLocation = locations.remove("excludes");
            }
            return new PatternSet(this.includes != null ? this.includes : (this.base != null ? this.base.includes : null), this.excludes != null ? this.excludes : (this.base != null ? this.base.excludes : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), includesLocation != null ? includesLocation : (this.base != null ? this.base.includesLocation : null), excludesLocation != null ? excludesLocation : (this.base != null ? this.base.excludesLocation : null));
        }
    }
}

