/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ModelBase
implements Serializable,
InputLocationTracker {
    final List<String> modules;
    final DistributionManagement distributionManagement;
    final Map<String, String> properties;
    final DependencyManagement dependencyManagement;
    final List<Dependency> dependencies;
    final List<Repository> repositories;
    final List<Repository> pluginRepositories;
    final Reporting reporting;
    final Map<Object, InputLocation> locations;

    ModelBase(Collection<String> modules, DistributionManagement distributionManagement, Map<String, String> properties, DependencyManagement dependencyManagement, Collection<Dependency> dependencies, Collection<Repository> repositories, Collection<Repository> pluginRepositories, Reporting reporting, Map<Object, InputLocation> locations) {
        this.modules = ImmutableCollections.copy(modules);
        this.distributionManagement = distributionManagement;
        this.properties = ImmutableCollections.copy(properties);
        this.dependencyManagement = dependencyManagement;
        this.dependencies = ImmutableCollections.copy(dependencies);
        this.repositories = ImmutableCollections.copy(repositories);
        this.pluginRepositories = ImmutableCollections.copy(pluginRepositories);
        this.reporting = reporting;
        this.locations = ImmutableCollections.copy(locations);
    }

    @Nonnull
    public List<String> getModules() {
        return this.modules;
    }

    public DistributionManagement getDistributionManagement() {
        return this.distributionManagement;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Nonnull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    @Nonnull
    public List<Repository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    public Reporting getReporting() {
        return this.reporting;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return ModelBase.newBuilder(this);
    }

    @Nonnull
    public ModelBase withModules(Collection<String> modules) {
        return ModelBase.newBuilder(this, true).modules(modules).build();
    }

    @Nonnull
    public ModelBase withDistributionManagement(DistributionManagement distributionManagement) {
        return ModelBase.newBuilder(this, true).distributionManagement(distributionManagement).build();
    }

    @Nonnull
    public ModelBase withProperties(Map<String, String> properties) {
        return ModelBase.newBuilder(this, true).properties(properties).build();
    }

    @Nonnull
    public ModelBase withDependencyManagement(DependencyManagement dependencyManagement) {
        return ModelBase.newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }

    @Nonnull
    public ModelBase withDependencies(Collection<Dependency> dependencies) {
        return ModelBase.newBuilder(this, true).dependencies(dependencies).build();
    }

    @Nonnull
    public ModelBase withRepositories(Collection<Repository> repositories) {
        return ModelBase.newBuilder(this, true).repositories(repositories).build();
    }

    @Nonnull
    public ModelBase withPluginRepositories(Collection<Repository> pluginRepositories) {
        return ModelBase.newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }

    @Nonnull
    public ModelBase withReporting(Reporting reporting) {
        return ModelBase.newBuilder(this, true).reporting(reporting).build();
    }

    @Nonnull
    public static ModelBase newInstance() {
        return ModelBase.newInstance(true);
    }

    @Nonnull
    public static ModelBase newInstance(boolean withDefaults) {
        return ModelBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ModelBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ModelBase from) {
        return ModelBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ModelBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        ModelBase base;
        Collection<String> modules;
        DistributionManagement distributionManagement;
        Map<String, String> properties;
        DependencyManagement dependencyManagement;
        Collection<Dependency> dependencies;
        Collection<Repository> repositories;
        Collection<Repository> pluginRepositories;
        Reporting reporting;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(ModelBase base, boolean forceCopy) {
            if (forceCopy) {
                this.modules = base.modules;
                this.distributionManagement = base.distributionManagement;
                this.properties = base.properties;
                this.dependencyManagement = base.dependencyManagement;
                this.dependencies = base.dependencies;
                this.repositories = base.repositories;
                this.pluginRepositories = base.pluginRepositories;
                this.reporting = base.reporting;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public ModelBase build() {
            if (!(this.base == null || this.modules != null && this.modules != this.base.modules || this.distributionManagement != null && this.distributionManagement != this.base.distributionManagement || this.properties != null && this.properties != this.base.properties || this.dependencyManagement != null && this.dependencyManagement != this.base.dependencyManagement || this.dependencies != null && this.dependencies != this.base.dependencies || this.repositories != null && this.repositories != this.base.repositories || this.pluginRepositories != null && this.pluginRepositories != this.base.pluginRepositories || this.reporting != null && this.reporting != this.base.reporting)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object modulesLocation = null;
            Object distributionManagementLocation = null;
            Object propertiesLocation = null;
            Object dependencyManagementLocation = null;
            Object dependenciesLocation = null;
            Object repositoriesLocation = null;
            Object pluginRepositoriesLocation = null;
            Object reportingLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new ModelBase(this.modules != null ? this.modules : (this.base != null ? this.base.modules : null), this.distributionManagement != null ? this.distributionManagement : (this.base != null ? this.base.distributionManagement : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), this.dependencyManagement != null ? this.dependencyManagement : (this.base != null ? this.base.dependencyManagement : null), this.dependencies != null ? this.dependencies : (this.base != null ? this.base.dependencies : null), this.repositories != null ? this.repositories : (this.base != null ? this.base.repositories : null), this.pluginRepositories != null ? this.pluginRepositories : (this.base != null ? this.base.pluginRepositories : null), this.reporting != null ? this.reporting : (this.base != null ? this.base.reporting : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

