// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Configures one method for notifying users/developers when a build breaks.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Notifier
    implements Serializable, InputLocationTracker
{
    /**
     * The mechanism used to deliver notifications.
     */
    final String type;
    /**
     * Whether to send notifications on error.
     */
    final boolean sendOnError;
    /**
     * Whether to send notifications on failure.
     */
    final boolean sendOnFailure;
    /**
     * Whether to send notifications on success.
     */
    final boolean sendOnSuccess;
    /**
     * Whether to send notifications on warning.
     */
    final boolean sendOnWarning;
    /**
     * @deprecated Where to send the notification to - eg email address.
     */
    final String address;
    /**
     * Extended configuration specific to this notifier goes here.
     */
    final Map<String, String> configuration;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Notifier(
        String type,
        boolean sendOnError,
        boolean sendOnFailure,
        boolean sendOnSuccess,
        boolean sendOnWarning,
        String address,
        Map<String, String> configuration,
        Map<Object, InputLocation> locations
    ) {
        this.type = type;
        this.sendOnError = sendOnError;
        this.sendOnFailure = sendOnFailure;
        this.sendOnSuccess = sendOnSuccess;
        this.sendOnWarning = sendOnWarning;
        this.address = address;
        this.configuration = ImmutableCollections.copy(configuration);
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The mechanism used to deliver notifications.
     *
     * @return a {@code String}
     */
    public String getType() {
        return this.type;
    }

    /**
     * Whether to send notifications on error.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnError() {
        return this.sendOnError;
    }

    /**
     * Whether to send notifications on failure.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnFailure() {
        return this.sendOnFailure;
    }

    /**
     * Whether to send notifications on success.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnSuccess() {
        return this.sendOnSuccess;
    }

    /**
     * Whether to send notifications on warning.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnWarning() {
        return this.sendOnWarning;
    }

    /**
     * @deprecated Where to send the notification to - eg email address.
     *
     * @return a {@code String}
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * Extended configuration specific to this notifier goes here.
     *
     * @return a {@code Map<String, String>}
     */
    @Nonnull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Notifier} instance using the specified type.
     *
     * @param type the new {@code String} to use
     * @return a {@code Notifier} with the specified type
     */
    @Nonnull
    public Notifier withType(String type) {
        return newBuilder(this, true).type(type).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnError.
     *
     * @param sendOnError the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnError
     */
    @Nonnull
    public Notifier withSendOnError(boolean sendOnError) {
        return newBuilder(this, true).sendOnError(sendOnError).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnFailure.
     *
     * @param sendOnFailure the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnFailure
     */
    @Nonnull
    public Notifier withSendOnFailure(boolean sendOnFailure) {
        return newBuilder(this, true).sendOnFailure(sendOnFailure).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnSuccess.
     *
     * @param sendOnSuccess the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnSuccess
     */
    @Nonnull
    public Notifier withSendOnSuccess(boolean sendOnSuccess) {
        return newBuilder(this, true).sendOnSuccess(sendOnSuccess).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnWarning.
     *
     * @param sendOnWarning the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnWarning
     */
    @Nonnull
    public Notifier withSendOnWarning(boolean sendOnWarning) {
        return newBuilder(this, true).sendOnWarning(sendOnWarning).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified address.
     *
     * @param address the new {@code String} to use
     * @return a {@code Notifier} with the specified address
     */
    @Nonnull
    public Notifier withAddress(String address) {
        return newBuilder(this, true).address(address).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified configuration.
     *
     * @param configuration the new {@code Map<String, String>} to use
     * @return a {@code Notifier} with the specified configuration
     */
    @Nonnull
    public Notifier withConfiguration(Map<String, String> configuration) {
        return newBuilder(this, true).configuration(configuration).build();
    }

    /**
     * Creates a new {@code Notifier} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Notifier}
     */
    @Nonnull
    public static Notifier newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Notifier} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Notifier}
     */
    @Nonnull
    public static Notifier newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Notifier} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Notifier} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Notifier} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Notifier} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Notifier from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Notifier} builder instance using the specified object as a basis.
     *
     * @param from the {@code Notifier} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Notifier from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Notifier instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Notifier base;
        String type;
        Boolean sendOnError;
        Boolean sendOnFailure;
        Boolean sendOnSuccess;
        Boolean sendOnWarning;
        String address;
        Map<String, String> configuration;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "mail";
                this.sendOnError = true;
                this.sendOnFailure = true;
                this.sendOnSuccess = true;
                this.sendOnWarning = true;
            }
        }

        Builder(Notifier base, boolean forceCopy) {
            if (forceCopy) {
                this.type = base.type;
                this.sendOnError = base.sendOnError;
                this.sendOnFailure = base.sendOnFailure;
                this.sendOnSuccess = base.sendOnSuccess;
                this.sendOnWarning = base.sendOnWarning;
                this.address = base.address;
                this.configuration = base.configuration;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder sendOnError(boolean sendOnError) {
            this.sendOnError = sendOnError;
            return this;
        }

        @Nonnull
        public Builder sendOnFailure(boolean sendOnFailure) {
            this.sendOnFailure = sendOnFailure;
            return this;
        }

        @Nonnull
        public Builder sendOnSuccess(boolean sendOnSuccess) {
            this.sendOnSuccess = sendOnSuccess;
            return this;
        }

        @Nonnull
        public Builder sendOnWarning(boolean sendOnWarning) {
            this.sendOnWarning = sendOnWarning;
            return this;
        }

        @Nonnull
        public Builder address(String address) {
            this.address = address;
            return this;
        }

        @Nonnull
        public Builder configuration(Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Notifier build() {
            if (base != null
                    && (type == null || type == base.type)
                    && (sendOnError == null || sendOnError == base.sendOnError)
                    && (sendOnFailure == null || sendOnFailure == base.sendOnFailure)
                    && (sendOnSuccess == null || sendOnSuccess == base.sendOnSuccess)
                    && (sendOnWarning == null || sendOnWarning == base.sendOnWarning)
                    && (address == null || address == base.address)
                    && (configuration == null || configuration == base.configuration)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("type", newlocs.containsKey("type") ? newlocs.get("type") : oldlocs.get("type"));
            locations.put("sendOnError", newlocs.containsKey("sendOnError") ? newlocs.get("sendOnError") : oldlocs.get("sendOnError"));
            locations.put("sendOnFailure", newlocs.containsKey("sendOnFailure") ? newlocs.get("sendOnFailure") : oldlocs.get("sendOnFailure"));
            locations.put("sendOnSuccess", newlocs.containsKey("sendOnSuccess") ? newlocs.get("sendOnSuccess") : oldlocs.get("sendOnSuccess"));
            locations.put("sendOnWarning", newlocs.containsKey("sendOnWarning") ? newlocs.get("sendOnWarning") : oldlocs.get("sendOnWarning"));
            locations.put("address", newlocs.containsKey("address") ? newlocs.get("address") : oldlocs.get("address"));
            locations.put("configuration", newlocs.containsKey("configuration") ? newlocs.get("configuration") : oldlocs.get("configuration"));
            return new Notifier(
                type != null ? type : (base != null ? base.type : null),
                sendOnError != null ? sendOnError : (base != null ? base.sendOnError : true),
                sendOnFailure != null ? sendOnFailure : (base != null ? base.sendOnFailure : true),
                sendOnSuccess != null ? sendOnSuccess : (base != null ? base.sendOnSuccess : true),
                sendOnWarning != null ? sendOnWarning : (base != null ? base.sendOnWarning : true),
                address != null ? address : (base != null ? base.address : null),
                configuration != null ? configuration : (base != null ? base.configuration : null),
                locations
            );
        }
    }

}
