// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Specifies the organization that produces this project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Organization
    implements Serializable, InputLocationTracker
{
    /**
     * The full name of the organization.
     */
    final String name;
    /**
     * The URL to the organization's home page.
     */
    final String url;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Organization(
        String name,
        String url,
        Map<Object, InputLocation> locations
    ) {
        this.name = name;
        this.url = url;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The full name of the organization.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The URL to the organization's home page.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Organization} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Organization} with the specified name
     */
    @Nonnull
    public Organization withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code Organization} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Organization} with the specified url
     */
    @Nonnull
    public Organization withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }

    /**
     * Creates a new {@code Organization} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Organization}
     */
    @Nonnull
    public static Organization newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Organization} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Organization}
     */
    @Nonnull
    public static Organization newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Organization} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Organization} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Organization} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Organization} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Organization from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Organization} builder instance using the specified object as a basis.
     *
     * @param from the {@code Organization} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Organization from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Organization instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Organization base;
        String name;
        String url;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(Organization base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Organization build() {
            if (base != null
                    && (name == null || name == base.name)
                    && (url == null || url == base.url)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("name", newlocs.containsKey("name") ? newlocs.get("name") : oldlocs.get("name"));
            locations.put("url", newlocs.containsKey("url") ? newlocs.get("url") : oldlocs.get("url"));
            return new Organization(
                name != null ? name : (base != null ? base.name : null),
                url != null ? url : (base != null ? base.url : null),
                locations
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Organization {name=" + getName() + ", url=" + getUrl() + "}";
    }
            
          
}
