// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Section for management of default plugin information for use in a group of POMs.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PluginManagement
    extends PluginContainer
    implements Serializable, InputLocationTracker
{

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    PluginManagement(
        Collection<Plugin> plugins,
        Map<Object, InputLocation> locations
    ) {
        super(
            plugins,
            locations
        );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PluginManagement} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code PluginManagement} with the specified plugins
     */
    @Nonnull
    public PluginManagement withPlugins(Collection<Plugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }

    /**
     * Creates a new {@code PluginManagement} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PluginManagement}
     */
    @Nonnull
    public static PluginManagement newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PluginManagement} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PluginManagement}
     */
    @Nonnull
    public static PluginManagement newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PluginManagement} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PluginManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PluginManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PluginManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginManagement from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PluginManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code PluginManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PluginManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends PluginContainer.Builder
    {
        PluginManagement base;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        Builder(PluginManagement base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PluginManagement build() {
            if (base != null
                    && (plugins == null || plugins == base.plugins)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("plugins", newlocs.containsKey("plugins") ? newlocs.get("plugins") : oldlocs.get("plugins"));
            return new PluginManagement(
                plugins != null ? plugins : (base != null ? base.plugins : null),
                locations
            );
        }
    }

}
