// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The conditions within the build runtime environment which will trigger the
 * automatic inclusion of the build profile. Multiple conditions can be defined, which must
 * be all satisfied to activate the profile.
 * 
 * <p>In addition to the traditional activation mechanisms (JDK version, OS properties,
 * file existence, etc.), Maven now supports a powerful condition-based activation
 * through the {@code condition} field. This new mechanism allows for more flexible
 * and expressive profile activation rules.</p>
 * 
 * <h2>Condition Syntax</h2>
 * 
 * <p>The condition is specified as a string expression that can include various
 * functions, comparisons, and logical operators. Some key features include:</p>
 * 
 * <ul>
 * <li>Property access: {@code ${property.name}}</li>
 * <li>Comparison operators: {@code ==}, {@code !=}, {@code <}, {@code >}, {@code <=}, {@code >=}</li>
 * <li>Logical operators: {@code &&} (AND), {@code ||} (OR), {@code not(...)}</li>
 * <li>Functions: {@code exists(...)}, {@code missing(...)}, {@code matches(...)}, {@code inrange(...)}, and more</li>
 * </ul>
 * 
 * <h2>Supported Functions</h2>
 * 
 * <p>The following functions are supported in condition expressions:</p>
 * 
 * <ul>
 * <li>{@code length(string)}: Returns the length of the given string.</li>
 * <li>{@code upper(string)}: Converts the string to uppercase.</li>
 * <li>{@code lower(string)}: Converts the string to lowercase.</li>
 * <li>{@code substring(string, start, [end])}: Returns a substring of the given string.</li>
 * <li>{@code indexOf(string, substring)}: Returns the index of the first occurrence of substring in string, or -1 if not found.</li>
 * <li>{@code contains(string, substring)}: Checks if the string contains the substring.</li>
 * <li>{@code matches(string, regex)}: Checks if the string matches the given regular expression.</li>
 * <li>{@code not(condition)}: Negates the given condition.</li>
 * <li>{@code if(condition, trueValue, falseValue)}: Returns trueValue if the condition is true, falseValue otherwise.</li>
 * <li>{@code exists(path)}: Checks if a file matching the given glob pattern exists.</li>
 * <li>{@code missing(path)}: Checks if a file matching the given glob pattern does not exist.</li>
 * <li>{@code inrange(version, range)}: Checks if the given version is within the specified version range.</li>
 * </ul>
 * 
 * <h2>Supported properties</h2>
 * 
 * <p>The following properties are supported in expressions:</p>
 * 
 * <ul>
 * <li>`project.basedir`: The project directory</li>
 * <li>`project.rootDirectory`: The root directory of the project</li>
 * <li>`project.artifactId`: The artifactId of the project</li>
 * <li>`project.packaging`: The packaging of the project</li>
 * <li>user properties</li>
 * <li>system properties (including environment variables prefixed with `env.`)</li>
 * </ul>
 * 
 * <h2>Examples</h2>
 * 
 * <ul>
 * <li>JDK version range: {@code inrange(${java.version}, '[11,)')} (JDK 11 or higher)</li>
 * <li>OS check: {@code ${os.name} == 'windows'}</li>
 * <li>File existence: {@code exists('${project.basedir}/src/**}{@code /*.xsd')}</li>
 * <li>Property check: {@code ${my.property} != 'some-value'}</li>
 * <li>Regex matching: {@code matches(${os.version}, '.*aws')}</li>
 * <li>Complex condition: {@code ${os.name} == 'windows' && ${os.arch} != 'amd64' && inrange(${os.version}, '[10,)')}</li>
 * <li>String length check: {@code length(${user.name}) > 5}</li>
 * <li>Substring with version: {@code substring(${java.version}, 0, 3) == '1.8'}</li>
 * <li>Using indexOf: {@code indexOf(${java.version}, '-') > 0}</li>
 * <li>Conditional logic: {@code if(contains(${java.version}, '-'), substring(${java.version}, 0, indexOf(${java.version}, '-')), ${java.version})}</li>
 * </ul>
 * 
 * <p>This flexible condition mechanism allows for more precise control over profile
 * activation, enabling developers to create profiles that respond to a wide range of
 * environmental factors and project states.</p>
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Activation
    implements Serializable, InputLocationTracker
{
    /**
     * If set to true, this profile will be active unless another profile in this
     * pom is activated using the command line -P option or by one of that profile's
     * activators.
     */
    final boolean activeByDefault;
    /**
     * Specifies that this profile will be activated when a matching JDK is detected.
     * For example, {@code 1.4} only activates on JDKs versioned 1.4,
     * while {@code !1.4} matches any JDK that is not version 1.4. Ranges are supported too:
     * {@code [1.5,)} activates when the JDK is 1.5 minimum.
     */
    final String jdk;
    /**
     * Specifies that this profile will be activated when matching operating system
     * attributes are detected.
     */
    final ActivationOS os;
    /**
     * Specifies that this profile will be activated when this property is
     * specified.
     */
    final ActivationProperty property;
    /**
     * Specifies that this profile will be activated based on existence of a file.
     */
    final ActivationFile file;
    /**
     * Specifies that this profile will be activated based on the project's packaging.
     */
    final String packaging;
    /**
     * The condition which must be satisfied to activate the profile.
     */
    final String condition;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Activation(Builder builder) {
        this.activeByDefault = builder.activeByDefault != null ? builder.activeByDefault : (builder.base != null ? builder.base.activeByDefault : false);
        this.jdk = builder.jdk != null ? builder.jdk : (builder.base != null ? builder.base.jdk : null);
        this.os = builder.os != null ? builder.os : (builder.base != null ? builder.base.os : null);
        this.property = builder.property != null ? builder.property : (builder.base != null ? builder.base.property : null);
        this.file = builder.file != null ? builder.file : (builder.base != null ? builder.base.file : null);
        this.packaging = builder.packaging != null ? builder.packaging : (builder.base != null ? builder.base.packaging : null);
        this.condition = builder.condition != null ? builder.condition : (builder.base != null ? builder.base.condition : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * If set to true, this profile will be active unless another profile in this
     * pom is activated using the command line -P option or by one of that profile's
     * activators.
     *
     * @return a {@code boolean}
     */
    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    /**
     * Specifies that this profile will be activated when a matching JDK is detected.
     * For example, {@code 1.4} only activates on JDKs versioned 1.4,
     * while {@code !1.4} matches any JDK that is not version 1.4. Ranges are supported too:
     * {@code [1.5,)} activates when the JDK is 1.5 minimum.
     *
     * @return a {@code String}
     */
    public String getJdk() {
        return this.jdk;
    }

    /**
     * Specifies that this profile will be activated when matching operating system
     * attributes are detected.
     *
     * @return a {@code ActivationOS}
     */
    public ActivationOS getOs() {
        return this.os;
    }

    /**
     * Specifies that this profile will be activated when this property is
     * specified.
     *
     * @return a {@code ActivationProperty}
     */
    public ActivationProperty getProperty() {
        return this.property;
    }

    /**
     * Specifies that this profile will be activated based on existence of a file.
     *
     * @return a {@code ActivationFile}
     */
    public ActivationFile getFile() {
        return this.file;
    }

    /**
     * Specifies that this profile will be activated based on the project's packaging.
     *
     * @return a {@code String}
     */
    public String getPackaging() {
        return this.packaging;
    }

    /**
     * The condition which must be satisfied to activate the profile.
     *
     * @return a {@code String}
     */
    public String getCondition() {
        return this.condition;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom()
    {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Activation} instance using the specified activeByDefault.
     *
     * @param activeByDefault the new {@code boolean} to use
     * @return a {@code Activation} with the specified activeByDefault
     */
    @Nonnull
    public Activation withActiveByDefault(boolean activeByDefault) {
        return newBuilder(this, true).activeByDefault(activeByDefault).build();
    }
    /**
     * Creates a new {@code Activation} instance using the specified jdk.
     *
     * @param jdk the new {@code String} to use
     * @return a {@code Activation} with the specified jdk
     */
    @Nonnull
    public Activation withJdk(String jdk) {
        return newBuilder(this, true).jdk(jdk).build();
    }
    /**
     * Creates a new {@code Activation} instance using the specified os.
     *
     * @param os the new {@code ActivationOS} to use
     * @return a {@code Activation} with the specified os
     */
    @Nonnull
    public Activation withOs(ActivationOS os) {
        return newBuilder(this, true).os(os).build();
    }
    /**
     * Creates a new {@code Activation} instance using the specified property.
     *
     * @param property the new {@code ActivationProperty} to use
     * @return a {@code Activation} with the specified property
     */
    @Nonnull
    public Activation withProperty(ActivationProperty property) {
        return newBuilder(this, true).property(property).build();
    }
    /**
     * Creates a new {@code Activation} instance using the specified file.
     *
     * @param file the new {@code ActivationFile} to use
     * @return a {@code Activation} with the specified file
     */
    @Nonnull
    public Activation withFile(ActivationFile file) {
        return newBuilder(this, true).file(file).build();
    }
    /**
     * Creates a new {@code Activation} instance using the specified packaging.
     *
     * @param packaging the new {@code String} to use
     * @return a {@code Activation} with the specified packaging
     */
    @Nonnull
    public Activation withPackaging(String packaging) {
        return newBuilder(this, true).packaging(packaging).build();
    }
    /**
     * Creates a new {@code Activation} instance using the specified condition.
     *
     * @param condition the new {@code String} to use
     * @return a {@code Activation} with the specified condition
     */
    @Nonnull
    public Activation withCondition(String condition) {
        return newBuilder(this, true).condition(condition).build();
    }

    /**
     * Creates a new {@code Activation} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Activation}
     */
    @Nonnull
    public static Activation newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Activation} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Activation}
     */
    @Nonnull
    public static Activation newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Activation} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Activation} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Activation} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Activation} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Activation from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Activation} builder instance using the specified object as a basis.
     *
     * @param from the {@code Activation} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Activation from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Activation instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Activation base;
        Boolean activeByDefault;
        String jdk;
        ActivationOS os;
        ActivationProperty property;
        ActivationFile file;
        String packaging;
        String condition;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.activeByDefault = false;
            }
        }

        protected Builder(Activation base, boolean forceCopy) {
            if (forceCopy) {
                this.activeByDefault = base.activeByDefault;
                this.jdk = base.jdk;
                this.os = base.os;
                this.property = base.property;
                this.file = base.file;
                this.packaging = base.packaging;
                this.condition = base.condition;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder activeByDefault(boolean activeByDefault) {
            this.activeByDefault = activeByDefault;
            return this;
        }

        @Nonnull
        public Builder jdk(String jdk) {
            this.jdk = jdk;
            return this;
        }

        @Nonnull
        public Builder os(ActivationOS os) {
            this.os = os;
            return this;
        }

        @Nonnull
        public Builder property(ActivationProperty property) {
            this.property = property;
            return this;
        }

        @Nonnull
        public Builder file(ActivationFile file) {
            this.file = file;
            return this;
        }

        @Nonnull
        public Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Nonnull
        public Builder condition(String condition) {
            this.condition = condition;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Activation build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (activeByDefault == null || activeByDefault == base.activeByDefault)
                    && (jdk == null || jdk == base.jdk)
                    && (os == null || os == base.os)
                    && (property == null || property == base.property)
                    && (file == null || file == base.file)
                    && (packaging == null || packaging == base.packaging)
                    && (condition == null || condition == base.condition)
            ) {
                return base;
            }
            return new Activation(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }

}
