// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Section for management of reports and their configuration.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Reporting
    implements Serializable, InputLocationTracker
{
    /**
     * If true, then the default reports are not included in the site generation.
     * This includes the reports in the "Project Info" menu. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     */
    final String excludeDefaults;
    /**
     * Where to store all the generated reports. The default is
     * {@code ${project.build.directory}/site}.
     */
    final String outputDirectory;
    /**
     * The reporting plugins to use and their configuration.
     */
    final List<ReportPlugin> plugins;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Reporting(Builder builder) {
        this.excludeDefaults = builder.excludeDefaults != null ? builder.excludeDefaults : (builder.base != null ? builder.base.excludeDefaults : null);
        this.outputDirectory = builder.outputDirectory != null ? builder.outputDirectory : (builder.base != null ? builder.base.outputDirectory : null);
        this.plugins = ImmutableCollections.copy(builder.plugins != null ? builder.plugins : (builder.base != null ? builder.base.plugins : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * If true, then the default reports are not included in the site generation.
     * This includes the reports in the "Project Info" menu. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     *
     * @return a {@code String}
     */
    public String getExcludeDefaults() {
        return this.excludeDefaults;
    }

    /**
     * Where to store all the generated reports. The default is
     * {@code ${project.build.directory}/site}.
     *
     * @return a {@code String}
     */
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    /**
     * The reporting plugins to use and their configuration.
     *
     * @return a {@code List<ReportPlugin>}
     */
    @Nonnull
    public List<ReportPlugin> getPlugins() {
        return this.plugins;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom()
    {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Reporting} instance using the specified excludeDefaults.
     *
     * @param excludeDefaults the new {@code String} to use
     * @return a {@code Reporting} with the specified excludeDefaults
     */
    @Nonnull
    public Reporting withExcludeDefaults(String excludeDefaults) {
        return newBuilder(this, true).excludeDefaults(excludeDefaults).build();
    }
    /**
     * Creates a new {@code Reporting} instance using the specified outputDirectory.
     *
     * @param outputDirectory the new {@code String} to use
     * @return a {@code Reporting} with the specified outputDirectory
     */
    @Nonnull
    public Reporting withOutputDirectory(String outputDirectory) {
        return newBuilder(this, true).outputDirectory(outputDirectory).build();
    }
    /**
     * Creates a new {@code Reporting} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<ReportPlugin>} to use
     * @return a {@code Reporting} with the specified plugins
     */
    @Nonnull
    public Reporting withPlugins(Collection<ReportPlugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }

    /**
     * Creates a new {@code Reporting} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Reporting}
     */
    @Nonnull
    public static Reporting newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Reporting} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Reporting}
     */
    @Nonnull
    public static Reporting newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Reporting} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Reporting} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Reporting} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Reporting} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Reporting from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Reporting} builder instance using the specified object as a basis.
     *
     * @param from the {@code Reporting} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Reporting from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Reporting instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Reporting base;
        String excludeDefaults;
        String outputDirectory;
        Collection<ReportPlugin> plugins;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(Reporting base, boolean forceCopy) {
            if (forceCopy) {
                this.excludeDefaults = base.excludeDefaults;
                this.outputDirectory = base.outputDirectory;
                this.plugins = base.plugins;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder excludeDefaults(String excludeDefaults) {
            this.excludeDefaults = excludeDefaults;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder plugins(Collection<ReportPlugin> plugins) {
            this.plugins = plugins;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Reporting build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (excludeDefaults == null || excludeDefaults == base.excludeDefaults)
                    && (outputDirectory == null || outputDirectory == base.outputDirectory)
                    && (plugins == null || plugins == base.plugins)
            ) {
                return base;
            }
            return new Reporting(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    public boolean isExcludeDefaults() {
        return (getExcludeDefaults() != null) ? Boolean.parseBoolean(getExcludeDefaults()) : false;
    }

            
          
}
