// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Contains the plugins information for the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PluginContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The list of plugins to use.
     */
    final List<Plugin> plugins;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected PluginContainer(Builder builder) {
        this.plugins = ImmutableCollections.copy(builder.plugins != null ? builder.plugins : (builder.base != null ? builder.base.plugins : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * The list of plugins to use.
     *
     * @return a {@code List<Plugin>}
     */
    @Nonnull
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PluginContainer} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code PluginContainer} with the specified plugins
     */
    @Nonnull
    public PluginContainer withPlugins(Collection<Plugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }

    /**
     * Creates a new {@code PluginContainer} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PluginContainer}
     */
    @Nonnull
    public static PluginContainer newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PluginContainer} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PluginContainer}
     */
    @Nonnull
    public static PluginContainer newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PluginContainer} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PluginContainer} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PluginContainer} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PluginContainer} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginContainer from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PluginContainer} builder instance using the specified object as a basis.
     *
     * @param from the {@code PluginContainer} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PluginContainer instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        PluginContainer base;
        Collection<Plugin> plugins;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(PluginContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.plugins = base.plugins;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public PluginContainer build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (plugins == null || plugins == base.plugins)
            ) {
                return base;
            }
            return new PluginContainer(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    volatile Map<String, Plugin> pluginMap;

    /**
     * @return a Map of plugins field with {@code Plugins#getKey()} as key
     * @see Plugin#getKey()
     */
    public Map<String, Plugin> getPluginsAsMap() {
        if (pluginMap == null) {
            synchronized (this) {
                if (pluginMap == null) {
                    pluginMap = ImmutableCollections.copy(plugins.stream().collect(
                            java.util.stream.Collectors.toMap(
                                Plugin::getKey, java.util.function.Function.identity())));
                }
            }
        }
        return pluginMap;
    }
            
          

            
     @Override
     public String toString()
     {
         return "PluginContainer {}";
     }
            
          
}
