// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <dependency>} element contains information about a dependency
 * of the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Dependency
    implements Serializable, InputLocationTracker
{
    /**
     * The project group that produced the dependency, e.g.
     * {@code org.apache.maven}.
     */
    final String groupId;
    /**
     * The unique id for an artifact produced by the project group, e.g.
     * {@code maven-artifact}.
     */
    final String artifactId;
    /**
     * The version requirement of the dependency, e.g. {@code 3.2.1}. The actual version will be resolved based on the usage context.
     * Version requirement can also be specified as a range of versions, e.g. {@code [3.2.0,)}. This is discouraged as it may break <i>predictability</i> of resolved version.
     * See <a href="https://s.apache.org/dependency-version">dependency version requirement documentation</a>
     * and <a href="https://s.apache.org/transitive-dependencies-resolution">transitive dependencies resolution</a> for more details.
     */
    final String version;
    /**
     * The type of dependency, that will be mapped to a file extension, an optional classifier, and a few other attributes.
     * Some examples are {@code jar}, {@code war}, {@code ejb-client}
     * and {@code test-jar}: see <a href="../maven-core/artifact-handlers.html">default
     * artifact handlers</a> for a list. New types can be defined by extensions, so this is not a complete list.
     */
    final String type;
    /**
     * The classifier of the dependency. It is appended to
     * the filename after the version. This allows:
     * <ul>
     * <li>referring to attached artifact, for example {@code sources} and {@code javadoc}:
     * see <a href="../maven-core/artifact-handlers.html">default artifact handlers</a> for a list,</li>
     * <li>distinguishing two artifacts
     * that belong to the same POM but were built differently.
     * For example, {@code jdk14} and {@code jdk15}.</li>
     * </ul>
     */
    final String classifier;
    /**
     * The scope of the dependency - {@code compile}, {@code runtime},
     * {@code test}, {@code system}, and {@code provided}. Used to
     * calculate the various classpaths used for compilation, testing, and so on.
     * It also assists in determining which artifacts to include in a distribution of
     * this project. For more information, see
     * <a href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     * dependency mechanism</a>. The default scope is {@code compile}.
     */
    final String scope;
    /**
     * FOR SYSTEM SCOPE ONLY. Note that use of this property is <b>discouraged</b>
     * and may be replaced in later versions. This specifies the path on the filesystem
     * for this dependency.
     * Requires an absolute path for the value, not relative.
     * Use a property that gives the machine specific absolute path,
     * e.g. {@code ${java.home}}.
     */
    final String systemPath;
    /**
     * Lists a set of artifacts that should be excluded from this dependency's
     * artifact list when it comes to calculating transitive dependencies.
     */
    final List<Exclusion> exclusions;
    /**
     * Indicates the dependency is optional for use of this library. While the
     * version of the dependency will be taken into account for dependency calculation if the
     * library is used elsewhere, it will not be passed on transitively. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     */
    final String optional;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Dependency(Builder builder) {
        this.groupId = builder.groupId != null ? builder.groupId : (builder.base != null ? builder.base.groupId : null);
        this.artifactId = builder.artifactId != null ? builder.artifactId : (builder.base != null ? builder.base.artifactId : null);
        this.version = builder.version != null ? builder.version : (builder.base != null ? builder.base.version : null);
        this.type = builder.type != null ? builder.type : (builder.base != null ? builder.base.type : null);
        this.classifier = builder.classifier != null ? builder.classifier : (builder.base != null ? builder.base.classifier : null);
        this.scope = builder.scope != null ? builder.scope : (builder.base != null ? builder.base.scope : null);
        this.systemPath = builder.systemPath != null ? builder.systemPath : (builder.base != null ? builder.base.systemPath : null);
        this.exclusions = ImmutableCollections.copy(builder.exclusions != null ? builder.exclusions : (builder.base != null ? builder.base.exclusions : null));
        this.optional = builder.optional != null ? builder.optional : (builder.base != null ? builder.base.optional : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * The project group that produced the dependency, e.g.
     * {@code org.apache.maven}.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The unique id for an artifact produced by the project group, e.g.
     * {@code maven-artifact}.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The version requirement of the dependency, e.g. {@code 3.2.1}. The actual version will be resolved based on the usage context.
     * Version requirement can also be specified as a range of versions, e.g. {@code [3.2.0,)}. This is discouraged as it may break <i>predictability</i> of resolved version.
     * See <a href="https://s.apache.org/dependency-version">dependency version requirement documentation</a>
     * and <a href="https://s.apache.org/transitive-dependencies-resolution">transitive dependencies resolution</a> for more details.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * The type of dependency, that will be mapped to a file extension, an optional classifier, and a few other attributes.
     * Some examples are {@code jar}, {@code war}, {@code ejb-client}
     * and {@code test-jar}: see <a href="../maven-core/artifact-handlers.html">default
     * artifact handlers</a> for a list. New types can be defined by extensions, so this is not a complete list.
     *
     * @return a {@code String}
     */
    public String getType() {
        return this.type;
    }

    /**
     * The classifier of the dependency. It is appended to
     * the filename after the version. This allows:
     * <ul>
     * <li>referring to attached artifact, for example {@code sources} and {@code javadoc}:
     * see <a href="../maven-core/artifact-handlers.html">default artifact handlers</a> for a list,</li>
     * <li>distinguishing two artifacts
     * that belong to the same POM but were built differently.
     * For example, {@code jdk14} and {@code jdk15}.</li>
     * </ul>
     *
     * @return a {@code String}
     */
    public String getClassifier() {
        return this.classifier;
    }

    /**
     * The scope of the dependency - {@code compile}, {@code runtime},
     * {@code test}, {@code system}, and {@code provided}. Used to
     * calculate the various classpaths used for compilation, testing, and so on.
     * It also assists in determining which artifacts to include in a distribution of
     * this project. For more information, see
     * <a href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     * dependency mechanism</a>. The default scope is {@code compile}.
     *
     * @return a {@code String}
     */
    public String getScope() {
        return this.scope;
    }

    /**
     * FOR SYSTEM SCOPE ONLY. Note that use of this property is <b>discouraged</b>
     * and may be replaced in later versions. This specifies the path on the filesystem
     * for this dependency.
     * Requires an absolute path for the value, not relative.
     * Use a property that gives the machine specific absolute path,
     * e.g. {@code ${java.home}}.
     *
     * @return a {@code String}
     */
    public String getSystemPath() {
        return this.systemPath;
    }

    /**
     * Lists a set of artifacts that should be excluded from this dependency's
     * artifact list when it comes to calculating transitive dependencies.
     *
     * @return a {@code List<Exclusion>}
     */
    @Nonnull
    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    /**
     * Indicates the dependency is optional for use of this library. While the
     * version of the dependency will be taken into account for dependency calculation if the
     * library is used elsewhere, it will not be passed on transitively. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     *
     * @return a {@code String}
     */
    public String getOptional() {
        return this.optional;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Dependency} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Dependency} with the specified groupId
     */
    @Nonnull
    public Dependency withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Dependency} with the specified artifactId
     */
    @Nonnull
    public Dependency withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Dependency} with the specified version
     */
    @Nonnull
    public Dependency withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified type.
     *
     * @param type the new {@code String} to use
     * @return a {@code Dependency} with the specified type
     */
    @Nonnull
    public Dependency withType(String type) {
        return newBuilder(this, true).type(type).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified classifier.
     *
     * @param classifier the new {@code String} to use
     * @return a {@code Dependency} with the specified classifier
     */
    @Nonnull
    public Dependency withClassifier(String classifier) {
        return newBuilder(this, true).classifier(classifier).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified scope.
     *
     * @param scope the new {@code String} to use
     * @return a {@code Dependency} with the specified scope
     */
    @Nonnull
    public Dependency withScope(String scope) {
        return newBuilder(this, true).scope(scope).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified systemPath.
     *
     * @param systemPath the new {@code String} to use
     * @return a {@code Dependency} with the specified systemPath
     */
    @Nonnull
    public Dependency withSystemPath(String systemPath) {
        return newBuilder(this, true).systemPath(systemPath).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified exclusions.
     *
     * @param exclusions the new {@code Collection<Exclusion>} to use
     * @return a {@code Dependency} with the specified exclusions
     */
    @Nonnull
    public Dependency withExclusions(Collection<Exclusion> exclusions) {
        return newBuilder(this, true).exclusions(exclusions).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified optional.
     *
     * @param optional the new {@code String} to use
     * @return a {@code Dependency} with the specified optional
     */
    @Nonnull
    public Dependency withOptional(String optional) {
        return newBuilder(this, true).optional(optional).build();
    }

    /**
     * Creates a new {@code Dependency} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Dependency}
     */
    @Nonnull
    public static Dependency newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Dependency} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Dependency}
     */
    @Nonnull
    public static Dependency newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Dependency} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Dependency} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Dependency} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Dependency} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Dependency from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Dependency} builder instance using the specified object as a basis.
     *
     * @param from the {@code Dependency} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Dependency from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Dependency instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Dependency base;
        String groupId;
        String artifactId;
        String version;
        String type;
        String classifier;
        String scope;
        String systemPath;
        Collection<Exclusion> exclusions;
        String optional;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "jar";
            }
        }

        protected Builder(Dependency base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.type = base.type;
                this.classifier = base.classifier;
                this.scope = base.scope;
                this.systemPath = base.systemPath;
                this.exclusions = base.exclusions;
                this.optional = base.optional;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Nonnull
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Nonnull
        public Builder systemPath(String systemPath) {
            this.systemPath = systemPath;
            return this;
        }

        @Nonnull
        public Builder exclusions(Collection<Exclusion> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        @Nonnull
        public Builder optional(String optional) {
            this.optional = optional;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Dependency build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (type == null || type == base.type)
                    && (classifier == null || classifier == base.classifier)
                    && (scope == null || scope == base.scope)
                    && (systemPath == null || systemPath == base.systemPath)
                    && (exclusions == null || exclusions == base.exclusions)
                    && (optional == null || optional == base.optional)
            ) {
                return base;
            }
            return new Dependency(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    public boolean isOptional() {
        return (getOptional() != null) ? Boolean.parseBoolean(getOptional()) : false;
    }

            
          

            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "Dependency {groupId=" + getGroupId() + ", artifactId=" + getArtifactId() + ", version=" + getVersion() + ", type=" + getType() + "}";
    }
            
          

            
    private volatile String managementKey;

    /**
     * @return the management key as {@code groupId:artifactId:type}
     */
    public String getManagementKey() {
        if (managementKey == null) {
            managementKey = (getGroupId() + ":" + getArtifactId() + ":" + getType() + (getClassifier() != null ? ":" + getClassifier() : "")).intern();
        }
        return managementKey;
    }
            
          
}
