// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Description of the sources associated with a project main code or unit tests.
 * The sources can be Java source files, generated source files, scripts, or resources for examples.
 * A source is specified by a {@code directory} element, which is relative to the POM.
 * The directory content can optionally be reduced to a subset with the {@code includes} and
 * {@code excludes} elements. The kind of sources (codes, resources, <i>etc.</i>) and their
 * usage (main code, tests, <i>etc.</i>) is specified by the {@code scope} element.
 * 
 * <h2>Default source directories</h2>
 * If no source directories are specified, the default values depend on whether module names are specified:
 * <ul>
 * <li>{@code src/${scope}/${lang}} if no module is specified</li>
 * <li>{@code src/${module}/${scope}/${lang}} if a module is specified</li>
 * </ul>
 * where
 * {@code ${scope}} is the value of the {@link #scope} element (typically {@code main} or {@code test}),
 * {@code ${lang}} is the value of the {@link #lang} element (typically {@code java} or {@code resources}),
 * and {@code ${module}} is the optional {@link #module} element.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Source
    extends FileSet
    implements Serializable, InputLocationTracker
{
    /**
     * Specifies in which context the source files will be used - typically {@code main} or {@code test}.
     * 
     * <p>The <b>main</b> scope is used for specifying a directory containing the source of the project.
     * The generated build system will compile the sources from this directory when the project is built.
     * The path given in the {@code directory} field is relative to the project descriptor.
     * The default directory for the default language (Java) is {@code "src/main/java"}.</p>
     * 
     * <p>The <b>test</b> scope is used for specifying a directory containing the unit test source of the project.
     * The generated build system will compile these directories when the project is being tested.
     * The path given in the {@code directory} field is relative to the project descriptor.
     * The default directory for the default language (Java) is {@code "src/test/java"}.</p>
     * 
     * <p>If no scope is specified, the default is {@code main}.</p>
     */
    final String scope;
    /**
     * Specifies the language of the source files - typically {@code java} or {@code resources}.
     * Resources is used as a generic term for scripting languages (e.g., JavaScript or Python)
     * or markup languages (e.g. properties file, <abbr>JSON</abbr> or <abbr>XML</abbr>).
     * 
     * <p>The <b>java</b> language is used for specifying a directory containing the Java sources of the project.
     * The generated build system will compile the sources from this directory using the Java compiler when the
     * project is built. The path given in the {@code directory} field is relative to the project descriptor.
     * The default directory for the main Java sources is {@code "src/main/java"}.</p>
     * 
     * <p>The <b>resources</b> language is used for specifying a directory containing the class-path
     * or module-path resources such as properties files or scripts associated with a project.
     * This directory is meant to be different from the main source directory,
     * in that its contents will be copied to the output directory in most cases
     * (since scripts are interpreted rather than compiled).
     * The default directory for the main resources is {@code "src/main/resources"}.</p>
     * 
     * <p>If no language is specified, the default is {@code java}.</p>
     */
    final String lang;
    /**
     * Name of the Java module (or other language-specific module) which is built by the sources.
     * This element can be specified in a Maven project containing multiple Java modules.
     * It is generally not needed for non-modular projects, or for modular projects having only one module.
     * 
     * <p>If a module name is specified for resources or script files,
     * then this value modifies the directory where the files will be copied.
     * For example, if a Java module name is "foo.biz", then the {@code foo/bar.properties}
     * resource file will be copied as {@code foo.biz/foo/bar.properties}.</p>
     * 
     * <p>This element can be combined with the {@code targetVersion} element for specifying sources,
     * scripts, or resources that are specific to both a particular module and a target version.</p>
     */
    final String module;
    /**
     * The version of the platform where the code will be executed.
     * In a Java environment, this is the value of the {@code --release} compiler option.
     * If a Java project contains multiple main sources with different target versions,
     * then a multi-version <abbr>JAR</abbr> file will be created
     * with the lowest version taken as the <dfn>base version</dfn>.
     * If this element is omitted, then the default target version is the compiler default value,
     * which is usually the version of the Java environment running Maven.
     * 
     * <p>If a target version, different from the base version, is specified for resources or script files,
     * then this value modifies the directory where the files will be copied.
     * For example, if {@code targetVersion} is 17, then the {@code foo/bar.properties}
     * resource file will be copied as {@code META-INF/versions/17/foo/bar.properties}.</p>
     * 
     * <p>This element can be combined with the {@code module} element for specifying sources,
     * scripts, or resources that are specific to both a particular module and a target version.</p>
     */
    final String targetVersion;
    /**
     * Specifies an explicit target path, overriding the default value.
     * The path is relative to the {@code ${project.build.outputDirectory}} directory,
     * which is typically {@code target/classes} in a Java project.
     * 
     * <p>When a target path is explicitly specified, the values of the {@code module} and {@code targetVersion}
     * elements are not used for inferring the path (they are still used as compiler options however).
     * It means that for scripts and resources, the files below the path specified by {@code directory}
     * are copied to the path specified by {@code targetPath} with the exact same directory structure.
     * It is user's responsibility to put module and version components in the {@code targetPath} if needed.</p>
     * 
     * <p>Note that for Java source files, a directory with the module name may still be generated despite
     * above statement about {@code module} being ignored, because that directory is generated by the Java
     * compiler rather than Maven.</p>
     */
    final String targetPath;
    /**
     * Whether resources are filtered to replace tokens with parameterized values.
     * The values are taken from the {@code properties} element and from the properties
     * in the files listed in the {@code filters} element.
     * 
     * <p>The default value is {@code false}.</p>
     */
    final boolean stringFiltering;
    /**
     * Whether the directory described by this source element should be included in the build.
     * This flag provides an easy way to include or exclude some sources depending, for example,
     * o property values defined in profiles. A use case is including optional resources only
     * when the user confirmed a license agreement.
     * 
     * <p>The default value is {@code true}.</p>
     */
    final boolean enabled;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Source(Builder builder) {
        super(builder);
        this.scope = builder.scope != null ? builder.scope : (builder.base != null ? builder.base.scope : null);
        this.lang = builder.lang != null ? builder.lang : (builder.base != null ? builder.base.lang : null);
        this.module = builder.module != null ? builder.module : (builder.base != null ? builder.base.module : null);
        this.targetVersion = builder.targetVersion != null ? builder.targetVersion : (builder.base != null ? builder.base.targetVersion : null);
        this.targetPath = builder.targetPath != null ? builder.targetPath : (builder.base != null ? builder.base.targetPath : null);
        this.stringFiltering = builder.stringFiltering != null ? builder.stringFiltering : (builder.base != null ? builder.base.stringFiltering : false);
        this.enabled = builder.enabled != null ? builder.enabled : (builder.base != null ? builder.base.enabled : true);
    }

    /**
     * Specifies in which context the source files will be used - typically {@code main} or {@code test}.
     * 
     * <p>The <b>main</b> scope is used for specifying a directory containing the source of the project.
     * The generated build system will compile the sources from this directory when the project is built.
     * The path given in the {@code directory} field is relative to the project descriptor.
     * The default directory for the default language (Java) is {@code "src/main/java"}.</p>
     * 
     * <p>The <b>test</b> scope is used for specifying a directory containing the unit test source of the project.
     * The generated build system will compile these directories when the project is being tested.
     * The path given in the {@code directory} field is relative to the project descriptor.
     * The default directory for the default language (Java) is {@code "src/test/java"}.</p>
     * 
     * <p>If no scope is specified, the default is {@code main}.</p>
     *
     * @return a {@code String}
     */
    public String getScope() {
        return this.scope;
    }

    /**
     * Specifies the language of the source files - typically {@code java} or {@code resources}.
     * Resources is used as a generic term for scripting languages (e.g., JavaScript or Python)
     * or markup languages (e.g. properties file, <abbr>JSON</abbr> or <abbr>XML</abbr>).
     * 
     * <p>The <b>java</b> language is used for specifying a directory containing the Java sources of the project.
     * The generated build system will compile the sources from this directory using the Java compiler when the
     * project is built. The path given in the {@code directory} field is relative to the project descriptor.
     * The default directory for the main Java sources is {@code "src/main/java"}.</p>
     * 
     * <p>The <b>resources</b> language is used for specifying a directory containing the class-path
     * or module-path resources such as properties files or scripts associated with a project.
     * This directory is meant to be different from the main source directory,
     * in that its contents will be copied to the output directory in most cases
     * (since scripts are interpreted rather than compiled).
     * The default directory for the main resources is {@code "src/main/resources"}.</p>
     * 
     * <p>If no language is specified, the default is {@code java}.</p>
     *
     * @return a {@code String}
     */
    public String getLang() {
        return this.lang;
    }

    /**
     * Name of the Java module (or other language-specific module) which is built by the sources.
     * This element can be specified in a Maven project containing multiple Java modules.
     * It is generally not needed for non-modular projects, or for modular projects having only one module.
     * 
     * <p>If a module name is specified for resources or script files,
     * then this value modifies the directory where the files will be copied.
     * For example, if a Java module name is "foo.biz", then the {@code foo/bar.properties}
     * resource file will be copied as {@code foo.biz/foo/bar.properties}.</p>
     * 
     * <p>This element can be combined with the {@code targetVersion} element for specifying sources,
     * scripts, or resources that are specific to both a particular module and a target version.</p>
     *
     * @return a {@code String}
     */
    public String getModule() {
        return this.module;
    }

    /**
     * The version of the platform where the code will be executed.
     * In a Java environment, this is the value of the {@code --release} compiler option.
     * If a Java project contains multiple main sources with different target versions,
     * then a multi-version <abbr>JAR</abbr> file will be created
     * with the lowest version taken as the <dfn>base version</dfn>.
     * If this element is omitted, then the default target version is the compiler default value,
     * which is usually the version of the Java environment running Maven.
     * 
     * <p>If a target version, different from the base version, is specified for resources or script files,
     * then this value modifies the directory where the files will be copied.
     * For example, if {@code targetVersion} is 17, then the {@code foo/bar.properties}
     * resource file will be copied as {@code META-INF/versions/17/foo/bar.properties}.</p>
     * 
     * <p>This element can be combined with the {@code module} element for specifying sources,
     * scripts, or resources that are specific to both a particular module and a target version.</p>
     *
     * @return a {@code String}
     */
    public String getTargetVersion() {
        return this.targetVersion;
    }

    /**
     * Specifies an explicit target path, overriding the default value.
     * The path is relative to the {@code ${project.build.outputDirectory}} directory,
     * which is typically {@code target/classes} in a Java project.
     * 
     * <p>When a target path is explicitly specified, the values of the {@code module} and {@code targetVersion}
     * elements are not used for inferring the path (they are still used as compiler options however).
     * It means that for scripts and resources, the files below the path specified by {@code directory}
     * are copied to the path specified by {@code targetPath} with the exact same directory structure.
     * It is user's responsibility to put module and version components in the {@code targetPath} if needed.</p>
     * 
     * <p>Note that for Java source files, a directory with the module name may still be generated despite
     * above statement about {@code module} being ignored, because that directory is generated by the Java
     * compiler rather than Maven.</p>
     *
     * @return a {@code String}
     */
    public String getTargetPath() {
        return this.targetPath;
    }

    /**
     * Whether resources are filtered to replace tokens with parameterized values.
     * The values are taken from the {@code properties} element and from the properties
     * in the files listed in the {@code filters} element.
     * 
     * <p>The default value is {@code false}.</p>
     *
     * @return a {@code boolean}
     */
    public boolean isStringFiltering() {
        return this.stringFiltering;
    }

    /**
     * Whether the directory described by this source element should be included in the build.
     * This flag provides an easy way to include or exclude some sources depending, for example,
     * o property values defined in profiles. A use case is including optional resources only
     * when the user confirmed a license agreement.
     * 
     * <p>The default value is {@code true}.</p>
     *
     * @return a {@code boolean}
     */
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Source} instance using the specified includes.
     *
     * @param includes the new {@code Collection<String>} to use
     * @return a {@code Source} with the specified includes
     */
    @Nonnull
    public Source withIncludes(Collection<String> includes) {
        return newBuilder(this, true).includes(includes).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified excludes.
     *
     * @param excludes the new {@code Collection<String>} to use
     * @return a {@code Source} with the specified excludes
     */
    @Nonnull
    public Source withExcludes(Collection<String> excludes) {
        return newBuilder(this, true).excludes(excludes).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code Source} with the specified directory
     */
    @Nonnull
    public Source withDirectory(String directory) {
        return newBuilder(this, true).directory(directory).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified scope.
     *
     * @param scope the new {@code String} to use
     * @return a {@code Source} with the specified scope
     */
    @Nonnull
    public Source withScope(String scope) {
        return newBuilder(this, true).scope(scope).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified lang.
     *
     * @param lang the new {@code String} to use
     * @return a {@code Source} with the specified lang
     */
    @Nonnull
    public Source withLang(String lang) {
        return newBuilder(this, true).lang(lang).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified module.
     *
     * @param module the new {@code String} to use
     * @return a {@code Source} with the specified module
     */
    @Nonnull
    public Source withModule(String module) {
        return newBuilder(this, true).module(module).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified targetVersion.
     *
     * @param targetVersion the new {@code String} to use
     * @return a {@code Source} with the specified targetVersion
     */
    @Nonnull
    public Source withTargetVersion(String targetVersion) {
        return newBuilder(this, true).targetVersion(targetVersion).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified targetPath.
     *
     * @param targetPath the new {@code String} to use
     * @return a {@code Source} with the specified targetPath
     */
    @Nonnull
    public Source withTargetPath(String targetPath) {
        return newBuilder(this, true).targetPath(targetPath).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified stringFiltering.
     *
     * @param stringFiltering the new {@code boolean} to use
     * @return a {@code Source} with the specified stringFiltering
     */
    @Nonnull
    public Source withStringFiltering(boolean stringFiltering) {
        return newBuilder(this, true).stringFiltering(stringFiltering).build();
    }
    /**
     * Creates a new {@code Source} instance using the specified enabled.
     *
     * @param enabled the new {@code boolean} to use
     * @return a {@code Source} with the specified enabled
     */
    @Nonnull
    public Source withEnabled(boolean enabled) {
        return newBuilder(this, true).enabled(enabled).build();
    }

    /**
     * Creates a new {@code Source} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Source}
     */
    @Nonnull
    public static Source newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Source} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Source}
     */
    @Nonnull
    public static Source newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Source} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Source} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Source} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Source} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Source from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Source} builder instance using the specified object as a basis.
     *
     * @param from the {@code Source} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Source from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Source instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends FileSet.Builder
    {
        Source base;
        String scope;
        String lang;
        String module;
        String targetVersion;
        String targetPath;
        Boolean stringFiltering;
        Boolean enabled;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.scope = "main";
                this.lang = "java";
                this.stringFiltering = false;
                this.enabled = true;
            }
        }

        protected Builder(Source base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.scope = base.scope;
                this.lang = base.lang;
                this.module = base.module;
                this.targetVersion = base.targetVersion;
                this.targetPath = base.targetPath;
                this.stringFiltering = base.stringFiltering;
                this.enabled = base.enabled;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Nonnull
        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @Nonnull
        public Builder module(String module) {
            this.module = module;
            return this;
        }

        @Nonnull
        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        @Nonnull
        public Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Nonnull
        public Builder stringFiltering(boolean stringFiltering) {
            this.stringFiltering = stringFiltering;
            return this;
        }

        @Nonnull
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Source build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (includes == null || includes == base.includes)
                    && (excludes == null || excludes == base.excludes)
                    && (directory == null || directory == base.directory)
                    && (scope == null || scope == base.scope)
                    && (lang == null || lang == base.lang)
                    && (module == null || module == base.module)
                    && (targetVersion == null || targetVersion == base.targetVersion)
                    && (targetPath == null || targetPath == base.targetPath)
                    && (stringFiltering == null || stringFiltering == base.stringFiltering)
                    && (enabled == null || enabled == base.enabled)
            ) {
                return base;
            }
            return new Source(this);
        }

    }

}
