// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Download policy.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryPolicy
    implements Serializable, InputLocationTracker
{
    /**
     * Whether to use this repository for downloading this type of artifact. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     */
    final String enabled;
    /**
     * The frequency for downloading updates - can be
     * {@code always},
     * {@code daily} (default),
     * {@code interval:XXX} (in minutes) or
     * {@code never} (only if it doesn't exist locally).
     */
    final String updatePolicy;
    /**
     * What to do when verification of an artifact checksum fails. Valid values are
     * {@code ignore},
     * {@code fail} (default for Maven 4 and above) or
     * {@code warn} (default for Maven 3).
     */
    final String checksumPolicy;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected RepositoryPolicy(Builder builder) {
        this.enabled = builder.enabled != null ? builder.enabled : (builder.base != null ? builder.base.enabled : null);
        this.updatePolicy = builder.updatePolicy != null ? builder.updatePolicy : (builder.base != null ? builder.base.updatePolicy : null);
        this.checksumPolicy = builder.checksumPolicy != null ? builder.checksumPolicy : (builder.base != null ? builder.base.checksumPolicy : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * Whether to use this repository for downloading this type of artifact. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     *
     * @return a {@code String}
     */
    public String getEnabled() {
        return this.enabled;
    }

    /**
     * The frequency for downloading updates - can be
     * {@code always},
     * {@code daily} (default),
     * {@code interval:XXX} (in minutes) or
     * {@code never} (only if it doesn't exist locally).
     *
     * @return a {@code String}
     */
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    /**
     * What to do when verification of an artifact checksum fails. Valid values are
     * {@code ignore},
     * {@code fail} (default for Maven 4 and above) or
     * {@code warn} (default for Maven 3).
     *
     * @return a {@code String}
     */
    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified enabled.
     *
     * @param enabled the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified enabled
     */
    @Nonnull
    public RepositoryPolicy withEnabled(String enabled) {
        return newBuilder(this, true).enabled(enabled).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified updatePolicy.
     *
     * @param updatePolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified updatePolicy
     */
    @Nonnull
    public RepositoryPolicy withUpdatePolicy(String updatePolicy) {
        return newBuilder(this, true).updatePolicy(updatePolicy).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified checksumPolicy.
     *
     * @param checksumPolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified checksumPolicy
     */
    @Nonnull
    public RepositoryPolicy withChecksumPolicy(String checksumPolicy) {
        return newBuilder(this, true).checksumPolicy(checksumPolicy).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create RepositoryPolicy instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        RepositoryPolicy base;
        String enabled;
        String updatePolicy;
        String checksumPolicy;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(RepositoryPolicy base, boolean forceCopy) {
            if (forceCopy) {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy(String updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy(String checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public RepositoryPolicy build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (enabled == null || enabled == base.enabled)
                    && (updatePolicy == null || updatePolicy == base.updatePolicy)
                    && (checksumPolicy == null || checksumPolicy == base.checksumPolicy)
            ) {
                return base;
            }
            return new RepositoryPolicy(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    public boolean isEnabled() {
        return (getEnabled() != null) ? Boolean.parseBoolean(getEnabled()) : true;
    }

            
          
}
