// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Contains the information needed for deploying websites.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Site
    implements Serializable, InputLocationTracker
{
    /**
     * A unique identifier for a deployment location. This is used to match the
     * site to configuration in the {@code settings.xml} file, for example.
     */
    final String id;
    /**
     * Human readable name of the deployment location.
     */
    final String name;
    /**
     * The url of the location where website is deployed, in the form {@code protocol://hostname/path}.
     * <p><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * site's {@code child.site.url.inherit.append.path="false"}.</p>
     */
    final String url;
    /**
     * When children inherit from distribution management site url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <p><b>Default value is</b>: {@code true}</p>
     * @since Maven 3.6.1
     */
    final String childSiteUrlInheritAppendPath;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Site(Builder builder) {
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
        this.name = builder.name != null ? builder.name : (builder.base != null ? builder.base.name : null);
        this.url = builder.url != null ? builder.url : (builder.base != null ? builder.base.url : null);
        this.childSiteUrlInheritAppendPath = builder.childSiteUrlInheritAppendPath != null ? builder.childSiteUrlInheritAppendPath : (builder.base != null ? builder.base.childSiteUrlInheritAppendPath : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * A unique identifier for a deployment location. This is used to match the
     * site to configuration in the {@code settings.xml} file, for example.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * Human readable name of the deployment location.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The url of the location where website is deployed, in the form {@code protocol://hostname/path}.
     * <p><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * site's {@code child.site.url.inherit.append.path="false"}.</p>
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * When children inherit from distribution management site url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <p><b>Default value is</b>: {@code true}</p>
     * @since Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildSiteUrlInheritAppendPath() {
        return this.childSiteUrlInheritAppendPath;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Site} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Site} with the specified id
     */
    @Nonnull
    public Site withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code Site} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Site} with the specified name
     */
    @Nonnull
    public Site withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code Site} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Site} with the specified url
     */
    @Nonnull
    public Site withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code Site} instance using the specified childSiteUrlInheritAppendPath.
     *
     * @param childSiteUrlInheritAppendPath the new {@code String} to use
     * @return a {@code Site} with the specified childSiteUrlInheritAppendPath
     */
    @Nonnull
    public Site withChildSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
        return newBuilder(this, true).childSiteUrlInheritAppendPath(childSiteUrlInheritAppendPath).build();
    }

    /**
     * Creates a new {@code Site} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Site}
     */
    @Nonnull
    public static Site newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Site} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Site}
     */
    @Nonnull
    public static Site newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Site} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Site} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Site} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Site} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Site from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Site} builder instance using the specified object as a basis.
     *
     * @param from the {@code Site} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Site from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Site instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Site base;
        String id;
        String name;
        String url;
        String childSiteUrlInheritAppendPath;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(Site base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.childSiteUrlInheritAppendPath = base.childSiteUrlInheritAppendPath;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
            this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Site build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
                    && (name == null || name == base.name)
                    && (url == null || url == base.url)
                    && (childSiteUrlInheritAppendPath == null || childSiteUrlInheritAppendPath == base.childSiteUrlInheritAppendPath)
            ) {
                return base;
            }
            return new Site(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            

    public boolean isChildSiteUrlInheritAppendPath() {
        return (getChildSiteUrlInheritAppendPath() != null) ? Boolean.parseBoolean(getChildSiteUrlInheritAppendPath()) : true;
    }

            
          
}
