/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class RepositoryBase
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final String name;
    final String url;
    final String layout;

    RepositoryBase(String id, String name, String url, String layout, Map<Object, InputLocation> locations) {
        super(id, locations);
        this.name = name;
        this.url = url;
        this.layout = layout;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLayout() {
        return this.layout;
    }

    @Override
    @Nonnull
    public Builder with() {
        return RepositoryBase.newBuilder(this);
    }

    @Override
    @Nonnull
    public RepositoryBase withId(String id) {
        return RepositoryBase.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public RepositoryBase withName(String name) {
        return RepositoryBase.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public RepositoryBase withUrl(String url) {
        return RepositoryBase.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public RepositoryBase withLayout(String layout) {
        return RepositoryBase.newBuilder(this, true).layout(layout).build();
    }

    @Nonnull
    public static RepositoryBase newInstance() {
        return RepositoryBase.newInstance(true);
    }

    @Nonnull
    public static RepositoryBase newInstance(boolean withDefaults) {
        return RepositoryBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return RepositoryBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryBase from) {
        return RepositoryBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        RepositoryBase base;
        String name;
        String url;
        String layout;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.layout = "default";
            }
        }

        Builder(RepositoryBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public RepositoryBase build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            locations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
            locations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
            locations.put("layout", newlocs.containsKey("layout") ? (InputLocation)newlocs.get("layout") : (InputLocation)oldlocs.get("layout"));
            return new RepositoryBase(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.layout != null ? this.layout : (this.base != null ? this.base.layout : null), locations);
        }
    }
}

