// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Repository contains the information needed
 * for establishing connections with remote repository
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryBase
    implements Serializable
{
    /**
     * A unique identifier for a repository.
     */
    final String id;
    /**
     * Human readable name of the repository.
     */
    final String name;
    /**
     * The url of the repository.
     */
    final String url;
    /**
     * The type of layout this repository uses for locating and
     * storing artifacts - can be "legacy" or "default".
     */
    final String layout;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    RepositoryBase(
        String id,
        String name,
        String url,
        String layout
    )
    {
        this.id = id;
        this.name = name;
        this.url = url;
        this.layout = layout;
    }

    /**
     * A unique identifier for a repository.
     *
     * @return a {@code String}
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * Human readable name of the repository.
     *
     * @return a {@code String}
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * The url of the repository.
     *
     * @return a {@code String}
     */
    public String getUrl()
    {
        return this.url;
    }

    /**
     * The type of layout this repository uses for locating and
     * storing artifacts - can be "legacy" or "default".
     *
     * @return a {@code String}
     */
    public String getLayout()
    {
        return this.layout;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified id
     */
    @Nonnull
    public RepositoryBase withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified name
     */
    @Nonnull
    public RepositoryBase withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified url
     */
    @Nonnull
    public RepositoryBase withUrl( String url )
    {
        return with().url( url ).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified layout.
     *
     * @param layout the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified layout
     */
    @Nonnull
    public RepositoryBase withLayout( String layout )
    {
        return with().layout( layout ).build();
    }

    /**
     * Creates a new {@code RepositoryBase} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryBase}
     */
    @Nonnull
    public static RepositoryBase newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code RepositoryBase} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryBase}
     */
    @Nonnull
    public static RepositoryBase newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code RepositoryBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryBase from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryBase from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create RepositoryBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        RepositoryBase base;
        String id;
        String name;
        String url;
        String layout;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
                this.layout = "default";
            }
        }

        Builder( RepositoryBase base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout( String layout )
        {
            this.layout = layout;
            return this;
        }


        @Nonnull
        public RepositoryBase build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( name == null || name == base.name )
                    && ( url == null || url == base.url )
                    && ( layout == null || layout == base.layout )
            )
            {
                return base;
            }
            return new RepositoryBase(
                id != null ? id : ( base != null ? base.id : null ),
                name != null ? name : ( base != null ? base.name : null ),
                url != null ? url : ( base != null ? base.url : null ),
                layout != null ? layout : ( base != null ? base.layout : null )
            );
        }
    }


            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object obj )
    {
        RepositoryBase other =  (RepositoryBase) obj;
        boolean retValue = false;
        if ( this.getId() != null )
        {
            retValue = this.getId().equals( other.getId() );
        }
        return retValue;
    }
            
          
}
