// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Download policy
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryPolicy
    implements Serializable
{
    /**
     * Whether to use this repository for downloading this type of
     * artifact.
     */
    final boolean enabled;
    /**
     * The frequency for downloading updates - can be "always",
     * "daily" (default), "interval:XXX" (in minutes) or "never"
     * (only if it doesn't exist locally).
     */
    final String updatePolicy;
    /**
     * What to do when verification of an artifact checksum fails. Valid values are "fail" (default for Maven 4 and
     * above), "warn" (default for Maven 2 and 3) or "ignore".
     */
    final String checksumPolicy;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    RepositoryPolicy(
        boolean enabled,
        String updatePolicy,
        String checksumPolicy
    )
    {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy;
        this.checksumPolicy = checksumPolicy;
    }

    /**
     * Whether to use this repository for downloading this type of
     * artifact.
     *
     * @return a {@code boolean}
     */
    public boolean isEnabled()
    {
        return this.enabled;
    }

    /**
     * The frequency for downloading updates - can be "always",
     * "daily" (default), "interval:XXX" (in minutes) or "never"
     * (only if it doesn't exist locally).
     *
     * @return a {@code String}
     */
    public String getUpdatePolicy()
    {
        return this.updatePolicy;
    }

    /**
     * What to do when verification of an artifact checksum fails. Valid values are "fail" (default for Maven 4 and
     * above), "warn" (default for Maven 2 and 3) or "ignore".
     *
     * @return a {@code String}
     */
    public String getChecksumPolicy()
    {
        return this.checksumPolicy;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified enabled.
     *
     * @param enabled the new {@code boolean} to use
     * @return a {@code RepositoryPolicy} with the specified enabled
     */
    @Nonnull
    public RepositoryPolicy withEnabled( boolean enabled )
    {
        return with().enabled( enabled ).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified updatePolicy.
     *
     * @param updatePolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified updatePolicy
     */
    @Nonnull
    public RepositoryPolicy withUpdatePolicy( String updatePolicy )
    {
        return with().updatePolicy( updatePolicy ).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified checksumPolicy.
     *
     * @param checksumPolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified checksumPolicy
     */
    @Nonnull
    public RepositoryPolicy withChecksumPolicy( String checksumPolicy )
    {
        return with().checksumPolicy( checksumPolicy ).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryPolicy from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryPolicy from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create RepositoryPolicy instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        RepositoryPolicy base;
        Boolean enabled;
        String updatePolicy;
        String checksumPolicy;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
                this.enabled = true;
            }
        }

        Builder( RepositoryPolicy base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled( boolean enabled )
        {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy( String updatePolicy )
        {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy( String checksumPolicy )
        {
            this.checksumPolicy = checksumPolicy;
            return this;
        }


        @Nonnull
        public RepositoryPolicy build()
        {
            if ( base != null
                    && ( enabled == null || enabled == base.enabled )
                    && ( updatePolicy == null || updatePolicy == base.updatePolicy )
                    && ( checksumPolicy == null || checksumPolicy == base.checksumPolicy )
            )
            {
                return base;
            }
            return new RepositoryPolicy(
                enabled != null ? enabled : ( base != null ? base.enabled : true ),
                updatePolicy != null ? updatePolicy : ( base != null ? base.updatePolicy : null ),
                checksumPolicy != null ? checksumPolicy : ( base != null ? base.checksumPolicy : null )
            );
        }
    }

}
