// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Root element of the user configuration file.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Settings
    extends TrackableBase
    implements Serializable
{
    final String modelEncoding;
    /**
     * The local repository.<br><b>Default value is:</b> <code>${user.home}/.m2/repository</code>
     */
    final String localRepository;
    /**
     * Whether Maven should attempt to interact with the user for input.
     */
    final boolean interactiveMode;
    /**
     * Whether Maven should use the plugin-registry.xml file to manage plugin versions.
     */
    final boolean usePluginRegistry;
    /**
     * Indicate whether maven should operate in offline mode full-time.
     */
    final boolean offline;
    /**
     * Configuration for different proxy profiles. Multiple proxy profiles
     * might come in handy for anyone working from a notebook or other
     * mobile platform, to enable easy switching of entire proxy
     * configurations by simply specifying the profile id, again either from
     * the command line or from the defaults section below.
     */
    final List<Proxy> proxies;
    /**
     * Configuration of server-specific settings, mainly authentication
     * method. This allows configuration of authentication on a per-server
     * basis.
     */
    final List<Server> servers;
    /**
     * Configuration of download mirrors for repositories.
     */
    final List<Mirror> mirrors;
    /**
     * Configuration of build profiles for adjusting the build
     * according to environmental parameters.
     */
    final List<Profile> profiles;
    /**
     * List of manually-activated build profiles, specified in the order in which
     * they should be applied.
     */
    final List<String> activeProfiles;
    /**
     * List of groupIds to search for a plugin when that plugin
     * groupId is not explicitly provided.
     */
    final List<String> pluginGroups;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Settings(
        String modelEncoding,
        String localRepository,
        boolean interactiveMode,
        boolean usePluginRegistry,
        boolean offline,
        Collection<Proxy> proxies,
        Collection<Server> servers,
        Collection<Mirror> mirrors,
        Collection<Profile> profiles,
        Collection<String> activeProfiles,
        Collection<String> pluginGroups
    )
    {
        super(
        );
        this.modelEncoding = modelEncoding;
        this.localRepository = localRepository;
        this.interactiveMode = interactiveMode;
        this.usePluginRegistry = usePluginRegistry;
        this.offline = offline;
        this.proxies = ImmutableCollections.copy( proxies );
        this.servers = ImmutableCollections.copy( servers );
        this.mirrors = ImmutableCollections.copy( mirrors );
        this.profiles = ImmutableCollections.copy( profiles );
        this.activeProfiles = ImmutableCollections.copy( activeProfiles );
        this.pluginGroups = ImmutableCollections.copy( pluginGroups );
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }

    /**
     * The local repository.<br><b>Default value is:</b> <code>${user.home}/.m2/repository</code>
     *
     * @return a {@code String}
     */
    public String getLocalRepository()
    {
        return this.localRepository;
    }

    /**
     * Whether Maven should attempt to interact with the user for input.
     *
     * @return a {@code boolean}
     */
    public boolean isInteractiveMode()
    {
        return this.interactiveMode;
    }

    /**
     * Whether Maven should use the plugin-registry.xml file to manage plugin versions.
     *
     * @return a {@code boolean}
     */
    public boolean isUsePluginRegistry()
    {
        return this.usePluginRegistry;
    }

    /**
     * Indicate whether maven should operate in offline mode full-time.
     *
     * @return a {@code boolean}
     */
    public boolean isOffline()
    {
        return this.offline;
    }

    /**
     * Configuration for different proxy profiles. Multiple proxy profiles
     * might come in handy for anyone working from a notebook or other
     * mobile platform, to enable easy switching of entire proxy
     * configurations by simply specifying the profile id, again either from
     * the command line or from the defaults section below.
     *
     * @return a {@code List<Proxy>}
     */
    @Nonnull
    public List<Proxy> getProxies()
    {
        return this.proxies;
    }

    /**
     * Configuration of server-specific settings, mainly authentication
     * method. This allows configuration of authentication on a per-server
     * basis.
     *
     * @return a {@code List<Server>}
     */
    @Nonnull
    public List<Server> getServers()
    {
        return this.servers;
    }

    /**
     * Configuration of download mirrors for repositories.
     *
     * @return a {@code List<Mirror>}
     */
    @Nonnull
    public List<Mirror> getMirrors()
    {
        return this.mirrors;
    }

    /**
     * Configuration of build profiles for adjusting the build
     * according to environmental parameters.
     *
     * @return a {@code List<Profile>}
     */
    @Nonnull
    public List<Profile> getProfiles()
    {
        return this.profiles;
    }

    /**
     * List of manually-activated build profiles, specified in the order in which
     * they should be applied.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getActiveProfiles()
    {
        return this.activeProfiles;
    }

    /**
     * List of groupIds to search for a plugin when that plugin
     * groupId is not explicitly provided.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getPluginGroups()
    {
        return this.pluginGroups;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Settings} instance using the specified localRepository.
     *
     * @param localRepository the new {@code String} to use
     * @return a {@code Settings} with the specified localRepository
     */
    @Nonnull
    public Settings withLocalRepository( String localRepository )
    {
        return with().localRepository( localRepository ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified interactiveMode.
     *
     * @param interactiveMode the new {@code boolean} to use
     * @return a {@code Settings} with the specified interactiveMode
     */
    @Nonnull
    public Settings withInteractiveMode( boolean interactiveMode )
    {
        return with().interactiveMode( interactiveMode ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified usePluginRegistry.
     *
     * @param usePluginRegistry the new {@code boolean} to use
     * @return a {@code Settings} with the specified usePluginRegistry
     */
    @Nonnull
    public Settings withUsePluginRegistry( boolean usePluginRegistry )
    {
        return with().usePluginRegistry( usePluginRegistry ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified offline.
     *
     * @param offline the new {@code boolean} to use
     * @return a {@code Settings} with the specified offline
     */
    @Nonnull
    public Settings withOffline( boolean offline )
    {
        return with().offline( offline ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified proxies.
     *
     * @param proxies the new {@code Collection<Proxy>} to use
     * @return a {@code Settings} with the specified proxies
     */
    @Nonnull
    public Settings withProxies( Collection<Proxy> proxies )
    {
        return with().proxies( proxies ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified servers.
     *
     * @param servers the new {@code Collection<Server>} to use
     * @return a {@code Settings} with the specified servers
     */
    @Nonnull
    public Settings withServers( Collection<Server> servers )
    {
        return with().servers( servers ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified mirrors.
     *
     * @param mirrors the new {@code Collection<Mirror>} to use
     * @return a {@code Settings} with the specified mirrors
     */
    @Nonnull
    public Settings withMirrors( Collection<Mirror> mirrors )
    {
        return with().mirrors( mirrors ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified profiles.
     *
     * @param profiles the new {@code Collection<Profile>} to use
     * @return a {@code Settings} with the specified profiles
     */
    @Nonnull
    public Settings withProfiles( Collection<Profile> profiles )
    {
        return with().profiles( profiles ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified activeProfiles.
     *
     * @param activeProfiles the new {@code Collection<String>} to use
     * @return a {@code Settings} with the specified activeProfiles
     */
    @Nonnull
    public Settings withActiveProfiles( Collection<String> activeProfiles )
    {
        return with().activeProfiles( activeProfiles ).build();
    }
    /**
     * Creates a new {@code Settings} instance using the specified pluginGroups.
     *
     * @param pluginGroups the new {@code Collection<String>} to use
     * @return a {@code Settings} with the specified pluginGroups
     */
    @Nonnull
    public Settings withPluginGroups( Collection<String> pluginGroups )
    {
        return with().pluginGroups( pluginGroups ).build();
    }

    /**
     * Creates a new {@code Settings} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Settings}
     */
    @Nonnull
    public static Settings newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Settings} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Settings}
     */
    @Nonnull
    public static Settings newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Settings} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Settings} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Settings} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Settings} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Settings from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Settings} builder instance using the specified object as a basis.
     *
     * @param from the {@code Settings} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Settings from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Settings instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends TrackableBase.Builder
    {
        Settings base;
        String modelEncoding;
        String localRepository;
        Boolean interactiveMode;
        Boolean usePluginRegistry;
        Boolean offline;
        Collection<Proxy> proxies;
        Collection<Server> servers;
        Collection<Mirror> mirrors;
        Collection<Profile> profiles;
        Collection<String> activeProfiles;
        Collection<String> pluginGroups;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.interactiveMode = true;
                this.usePluginRegistry = false;
                this.offline = false;
            }
        }

        Builder( Settings base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.localRepository = base.localRepository;
                this.interactiveMode = base.interactiveMode;
                this.usePluginRegistry = base.usePluginRegistry;
                this.offline = base.offline;
                this.proxies = base.proxies;
                this.servers = base.servers;
                this.mirrors = base.mirrors;
                this.profiles = base.profiles;
                this.activeProfiles = base.activeProfiles;
                this.pluginGroups = base.pluginGroups;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modelEncoding( String modelEncoding )
        {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder localRepository( String localRepository )
        {
            this.localRepository = localRepository;
            return this;
        }

        @Nonnull
        public Builder interactiveMode( boolean interactiveMode )
        {
            this.interactiveMode = interactiveMode;
            return this;
        }

        @Nonnull
        public Builder usePluginRegistry( boolean usePluginRegistry )
        {
            this.usePluginRegistry = usePluginRegistry;
            return this;
        }

        @Nonnull
        public Builder offline( boolean offline )
        {
            this.offline = offline;
            return this;
        }

        @Nonnull
        public Builder proxies( Collection<Proxy> proxies )
        {
            this.proxies = proxies;
            return this;
        }

        @Nonnull
        public Builder servers( Collection<Server> servers )
        {
            this.servers = servers;
            return this;
        }

        @Nonnull
        public Builder mirrors( Collection<Mirror> mirrors )
        {
            this.mirrors = mirrors;
            return this;
        }

        @Nonnull
        public Builder profiles( Collection<Profile> profiles )
        {
            this.profiles = profiles;
            return this;
        }

        @Nonnull
        public Builder activeProfiles( Collection<String> activeProfiles )
        {
            this.activeProfiles = activeProfiles;
            return this;
        }

        @Nonnull
        public Builder pluginGroups( Collection<String> pluginGroups )
        {
            this.pluginGroups = pluginGroups;
            return this;
        }


        @Nonnull
        public Settings build()
        {
            if ( base != null
                    && ( localRepository == null || localRepository == base.localRepository )
                    && ( interactiveMode == null || interactiveMode == base.interactiveMode )
                    && ( usePluginRegistry == null || usePluginRegistry == base.usePluginRegistry )
                    && ( offline == null || offline == base.offline )
                    && ( proxies == null || proxies == base.proxies )
                    && ( servers == null || servers == base.servers )
                    && ( mirrors == null || mirrors == base.mirrors )
                    && ( profiles == null || profiles == base.profiles )
                    && ( activeProfiles == null || activeProfiles == base.activeProfiles )
                    && ( pluginGroups == null || pluginGroups == base.pluginGroups )
            )
            {
                return base;
            }
            return new Settings(
                modelEncoding != null ? modelEncoding : ( base != null ? base.modelEncoding : "UTF-8" ),
                localRepository != null ? localRepository : ( base != null ? base.localRepository : null ),
                interactiveMode != null ? interactiveMode : ( base != null ? base.interactiveMode : true ),
                usePluginRegistry != null ? usePluginRegistry : ( base != null ? base.usePluginRegistry : false ),
                offline != null ? offline : ( base != null ? base.offline : false ),
                proxies != null ? proxies : ( base != null ? base.proxies : null ),
                servers != null ? servers : ( base != null ? base.servers : null ),
                mirrors != null ? mirrors : ( base != null ? base.mirrors : null ),
                profiles != null ? profiles : ( base != null ? base.profiles : null ),
                activeProfiles != null ? activeProfiles : ( base != null ? base.activeProfiles : null ),
                pluginGroups != null ? pluginGroups : ( base != null ? base.pluginGroups : null )
            );
        }
    }


            
    public Boolean getInteractiveMode()
    {
        return Boolean.valueOf( isInteractiveMode() );
    }

    private Proxy activeProxy;

    /**
     * Reset the <code>activeProxy</code> field to <code>null</code>
     */
    public void flushActiveProxy()
    {
        this.activeProxy = null;
    }

    /**
     * @return the first active proxy
     */
    public synchronized Proxy getActiveProxy()
    {
        if ( activeProxy == null )
        {
            java.util.List<Proxy> proxies = getProxies();
            if ( proxies != null && !proxies.isEmpty() )
            {
                for ( Proxy proxy : proxies )
                {
                    if ( proxy.isActive() )
                    {
                        activeProxy = proxy;
                        break;
                    }
                }
            }
        }

        return activeProxy;
    }

    public Server getServer( String serverId )
    {
        Server match = null;

        java.util.List<Server> servers = getServers();
        if ( servers != null && serverId != null )
        {
            for ( Server server : servers )
            {
                if ( serverId.equals( server.getId() ) )
                {
                    match = server;
                    break;
                }
            }
        }

        return match;
    }

    @Deprecated
    public Mirror getMirrorOf( String repositoryId )
    {
        Mirror match = null;

        java.util.List<Mirror> mirrors = getMirrors();
        if ( mirrors != null && repositoryId != null )
        {
            for ( Mirror mirror : mirrors )
            {
                if ( repositoryId.equals( mirror.getMirrorOf() ) )
                {
                    match = mirror;
                    break;
                }
            }
        }

        return match;
    }

    private java.util.Map<String, Profile> profileMap;

    /**
     * Reset the <code>profileMap</code> field to <code>null</code>
     */
    public void flushProfileMap()
    {
        this.profileMap = null;
    }

    /**
     * @return a Map of profiles field with <code>Profile#getId()</code> as key
     * @see Profile#getId()
     */
    public java.util.Map<String, Profile> getProfilesAsMap()
    {
        if ( profileMap == null )
        {
            profileMap = new java.util.LinkedHashMap<String, Profile>();

            if ( getProfiles() != null )
            {
                for ( Profile profile : getProfiles() )
                {
                    profileMap.put( profile.getId(), profile );
                }
            }
        }

        return profileMap;
    }
            
          
}
