/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class RepositoryBase
implements Serializable {
    final String id;
    final String name;
    final String url;
    final String layout;

    RepositoryBase(String id, String name, String url, String layout) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.layout = layout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RepositoryBase)) {
            return false;
        }
        RepositoryBase that = (RepositoryBase)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLayout() {
        return this.layout;
    }

    @Nonnull
    public Builder with() {
        return RepositoryBase.newBuilder(this);
    }

    @Nonnull
    public RepositoryBase withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public RepositoryBase withName(String name) {
        return this.with().name(name).build();
    }

    @Nonnull
    public RepositoryBase withUrl(String url) {
        return this.with().url(url).build();
    }

    @Nonnull
    public RepositoryBase withLayout(String layout) {
        return this.with().layout(layout).build();
    }

    @Nonnull
    public static RepositoryBase newInstance() {
        return RepositoryBase.newInstance(true);
    }

    @Nonnull
    public static RepositoryBase newInstance(boolean withDefaults) {
        return RepositoryBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return RepositoryBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryBase from) {
        return RepositoryBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        RepositoryBase base;
        String id;
        String name;
        String url;
        String layout;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.layout = "default";
            }
        }

        Builder(RepositoryBase base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public RepositoryBase build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout)) {
                return this.base;
            }
            return new RepositoryBase(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.layout != null ? this.layout : (this.base != null ? this.base.layout : null));
        }
    }
}

