// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Repository contains the information needed for establishing
 * connections with remote repository
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Repository
    extends RepositoryBase
    implements Serializable
{
    /**
     * How to handle downloading of releases from this repository
     */
    final RepositoryPolicy releases;
    /**
     * How to handle downloading of snapshots from this repository
     */
    final RepositoryPolicy snapshots;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Repository(
        String id,
        String name,
        String url,
        String layout,
        RepositoryPolicy releases,
        RepositoryPolicy snapshots
    )
    {
        super(
            id,
            name,
            url,
            layout
        );
        this.releases = releases;
        this.snapshots = snapshots;
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || !( o instanceof Repository ) )
        {
            return false;
        }
        Repository that = ( Repository ) o;
        return Objects.equals( this.id, that.id );
    }

    @Override
    public int hashCode()
    {
        return Objects.hash( id );
    }

    /**
     * How to handle downloading of releases from this repository
     *
     * @return a {@code RepositoryPolicy}
     */
    public RepositoryPolicy getReleases()
    {
        return this.releases;
    }

    /**
     * How to handle downloading of snapshots from this repository
     *
     * @return a {@code RepositoryPolicy}
     */
    public RepositoryPolicy getSnapshots()
    {
        return this.snapshots;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Repository} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Repository} with the specified id
     */
    @Nonnull
    public Repository withId( String id )
    {
        return newBuilder(this, true).id( id ).build();
    }
    /**
     * Creates a new {@code Repository} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Repository} with the specified name
     */
    @Nonnull
    public Repository withName( String name )
    {
        return newBuilder(this, true).name( name ).build();
    }
    /**
     * Creates a new {@code Repository} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Repository} with the specified url
     */
    @Nonnull
    public Repository withUrl( String url )
    {
        return newBuilder(this, true).url( url ).build();
    }
    /**
     * Creates a new {@code Repository} instance using the specified layout.
     *
     * @param layout the new {@code String} to use
     * @return a {@code Repository} with the specified layout
     */
    @Nonnull
    public Repository withLayout( String layout )
    {
        return newBuilder(this, true).layout( layout ).build();
    }
    /**
     * Creates a new {@code Repository} instance using the specified releases.
     *
     * @param releases the new {@code RepositoryPolicy} to use
     * @return a {@code Repository} with the specified releases
     */
    @Nonnull
    public Repository withReleases( RepositoryPolicy releases )
    {
        return newBuilder(this, true).releases( releases ).build();
    }
    /**
     * Creates a new {@code Repository} instance using the specified snapshots.
     *
     * @param snapshots the new {@code RepositoryPolicy} to use
     * @return a {@code Repository} with the specified snapshots
     */
    @Nonnull
    public Repository withSnapshots( RepositoryPolicy snapshots )
    {
        return newBuilder(this, true).snapshots( snapshots ).build();
    }

    /**
     * Creates a new {@code Repository} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Repository}
     */
    @Nonnull
    public static Repository newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Repository} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Repository}
     */
    @Nonnull
    public static Repository newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Repository} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Repository} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Repository} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Repository} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Repository from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Repository} builder instance using the specified object as a basis.
     *
     * @param from the {@code Repository} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Repository from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Repository instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends RepositoryBase.Builder
    {
        Repository base;
        RepositoryPolicy releases;
        RepositoryPolicy snapshots;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
            }
        }

        Builder( Repository base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.releases = base.releases;
                this.snapshots = base.snapshots;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout( String layout )
        {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder releases( RepositoryPolicy releases )
        {
            this.releases = releases;
            return this;
        }

        @Nonnull
        public Builder snapshots( RepositoryPolicy snapshots )
        {
            this.snapshots = snapshots;
            return this;
        }


        @Nonnull
        public Repository build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( name == null || name == base.name )
                    && ( url == null || url == base.url )
                    && ( layout == null || layout == base.layout )
                    && ( releases == null || releases == base.releases )
                    && ( snapshots == null || snapshots == base.snapshots )
            )
            {
                return base;
            }
            return new Repository(
                id != null ? id : ( base != null ? base.id : null ),
                name != null ? name : ( base != null ? base.name : null ),
                url != null ? url : ( base != null ? base.url : null ),
                layout != null ? layout : ( base != null ? base.layout : null ),
                releases != null ? releases : ( base != null ? base.releases : null ),
                snapshots != null ? snapshots : ( base != null ? base.snapshots : null )
            );
        }
    }

}
