/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Proxy
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final boolean active;
    final String protocol;
    final String username;
    final String password;
    final int port;
    final String host;
    final String nonProxyHosts;

    Proxy(String id, boolean active, String protocol, String username, String password, int port, String host, String nonProxyHosts, Map<Object, InputLocation> locations) {
        super(id, locations);
        this.active = active;
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.port = port;
        this.host = host;
        this.nonProxyHosts = nonProxyHosts;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Proxy.newBuilder(this);
    }

    @Override
    @Nonnull
    public Proxy withId(String id) {
        return Proxy.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Proxy withActive(boolean active) {
        return Proxy.newBuilder(this, true).active(active).build();
    }

    @Nonnull
    public Proxy withProtocol(String protocol) {
        return Proxy.newBuilder(this, true).protocol(protocol).build();
    }

    @Nonnull
    public Proxy withUsername(String username) {
        return Proxy.newBuilder(this, true).username(username).build();
    }

    @Nonnull
    public Proxy withPassword(String password) {
        return Proxy.newBuilder(this, true).password(password).build();
    }

    @Nonnull
    public Proxy withPort(int port) {
        return Proxy.newBuilder(this, true).port(port).build();
    }

    @Nonnull
    public Proxy withHost(String host) {
        return Proxy.newBuilder(this, true).host(host).build();
    }

    @Nonnull
    public Proxy withNonProxyHosts(String nonProxyHosts) {
        return Proxy.newBuilder(this, true).nonProxyHosts(nonProxyHosts).build();
    }

    @Nonnull
    public static Proxy newInstance() {
        return Proxy.newInstance(true);
    }

    @Nonnull
    public static Proxy newInstance(boolean withDefaults) {
        return Proxy.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Proxy.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Proxy from) {
        return Proxy.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Proxy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Proxy base;
        Boolean active;
        String protocol;
        String username;
        String password;
        Integer port;
        String host;
        String nonProxyHosts;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.active = true;
                this.protocol = "http";
                this.port = 8080;
            }
        }

        Builder(Proxy base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.active = base.active;
                this.protocol = base.protocol;
                this.username = base.username;
                this.password = base.password;
                this.port = base.port;
                this.host = base.host;
                this.nonProxyHosts = base.nonProxyHosts;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Nonnull
        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Nonnull
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Nonnull
        public Builder nonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Proxy build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.active != null && this.active != this.base.active || this.protocol != null && this.protocol != this.base.protocol || this.username != null && this.username != this.base.username || this.password != null && this.password != this.base.password || this.port != null && this.port != this.base.port || this.host != null && this.host != this.base.host || this.nonProxyHosts != null && this.nonProxyHosts != this.base.nonProxyHosts)) {
                return this.base;
            }
            Map locations = null;
            Object location = null;
            Object idLocation = null;
            Object activeLocation = null;
            Object protocolLocation = null;
            Object usernameLocation = null;
            Object passwordLocation = null;
            Object portLocation = null;
            Object hostLocation = null;
            Object nonProxyHostsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Proxy(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.active != null ? this.active : (this.base != null ? this.base.active : true), this.protocol != null ? this.protocol : (this.base != null ? this.base.protocol : null), this.username != null ? this.username : (this.base != null ? this.base.username : null), this.password != null ? this.password : (this.base != null ? this.base.password : null), this.port != null ? this.port : (this.base != null ? this.base.port : 8080), this.host != null ? this.host : (this.base != null ? this.base.host : null), this.nonProxyHosts != null ? this.nonProxyHosts : (this.base != null ? this.base.nonProxyHosts : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

