// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <proxy>} element contains information required to a proxy settings.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Proxy
    extends IdentifiableBase
    implements Serializable, InputLocationTracker
{
    /**
     * Whether this proxy configuration is the active one. Note: While the type of this field
     * is {@code String} for technical reasons, the semantic type is actually {@code boolean}.
     * @see #isActive()
     */
    final String activeString;
    /**
     * The proxy protocol.
     */
    final String protocol;
    /**
     * The proxy user.
     */
    final String username;
    /**
     * The proxy password.
     */
    final String password;
    /**
     * The proxy port. Note: While the type of this field is {@code String} for technical
     * reasons, the semantic type is actually {@code int}.
     * @see #getPort()
     */
    final String portString;
    /**
     * The proxy host.
     */
    final String host;
    /**
     * The list of non-proxied hosts (delimited by {@code |}).
     */
    final String nonProxyHosts;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Proxy(
        String id,
        String activeString,
        String protocol,
        String username,
        String password,
        String portString,
        String host,
        String nonProxyHosts,
        Map<Object, InputLocation> locations
    ) {
        super(
            id,
            locations
        );
        this.activeString = activeString;
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.portString = portString;
        this.host = host;
        this.nonProxyHosts = nonProxyHosts;
    }

    /**
     * Whether this proxy configuration is the active one. Note: While the type of this field
     * is {@code String} for technical reasons, the semantic type is actually {@code boolean}.
     * @see #isActive()
     *
     * @return a {@code String}
     */
    public String getActiveString() {
        return this.activeString;
    }

    /**
     * The proxy protocol.
     *
     * @return a {@code String}
     */
    public String getProtocol() {
        return this.protocol;
    }

    /**
     * The proxy user.
     *
     * @return a {@code String}
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * The proxy password.
     *
     * @return a {@code String}
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * The proxy port. Note: While the type of this field is {@code String} for technical
     * reasons, the semantic type is actually {@code int}.
     * @see #getPort()
     *
     * @return a {@code String}
     */
    public String getPortString() {
        return this.portString;
    }

    /**
     * The proxy host.
     *
     * @return a {@code String}
     */
    public String getHost() {
        return this.host;
    }

    /**
     * The list of non-proxied hosts (delimited by {@code |}).
     *
     * @return a {@code String}
     */
    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Proxy} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Proxy} with the specified id
     */
    @Nonnull
    public Proxy withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified activeString.
     *
     * @param activeString the new {@code String} to use
     * @return a {@code Proxy} with the specified activeString
     */
    @Nonnull
    public Proxy withActiveString(String activeString) {
        return newBuilder(this, true).activeString(activeString).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified protocol.
     *
     * @param protocol the new {@code String} to use
     * @return a {@code Proxy} with the specified protocol
     */
    @Nonnull
    public Proxy withProtocol(String protocol) {
        return newBuilder(this, true).protocol(protocol).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified username.
     *
     * @param username the new {@code String} to use
     * @return a {@code Proxy} with the specified username
     */
    @Nonnull
    public Proxy withUsername(String username) {
        return newBuilder(this, true).username(username).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified password.
     *
     * @param password the new {@code String} to use
     * @return a {@code Proxy} with the specified password
     */
    @Nonnull
    public Proxy withPassword(String password) {
        return newBuilder(this, true).password(password).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified portString.
     *
     * @param portString the new {@code String} to use
     * @return a {@code Proxy} with the specified portString
     */
    @Nonnull
    public Proxy withPortString(String portString) {
        return newBuilder(this, true).portString(portString).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified host.
     *
     * @param host the new {@code String} to use
     * @return a {@code Proxy} with the specified host
     */
    @Nonnull
    public Proxy withHost(String host) {
        return newBuilder(this, true).host(host).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified nonProxyHosts.
     *
     * @param nonProxyHosts the new {@code String} to use
     * @return a {@code Proxy} with the specified nonProxyHosts
     */
    @Nonnull
    public Proxy withNonProxyHosts(String nonProxyHosts) {
        return newBuilder(this, true).nonProxyHosts(nonProxyHosts).build();
    }

    /**
     * Creates a new {@code Proxy} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Proxy}
     */
    @Nonnull
    public static Proxy newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Proxy} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Proxy}
     */
    @Nonnull
    public static Proxy newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Proxy} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Proxy} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Proxy} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Proxy} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Proxy from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Proxy} builder instance using the specified object as a basis.
     *
     * @param from the {@code Proxy} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Proxy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Proxy instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends IdentifiableBase.Builder
    {
        Proxy base;
        String activeString;
        String protocol;
        String username;
        String password;
        String portString;
        String host;
        String nonProxyHosts;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.activeString = "true";
                this.protocol = "http";
                this.portString = "8080";
            }
        }

        Builder(Proxy base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.activeString = base.activeString;
                this.protocol = base.protocol;
                this.username = base.username;
                this.password = base.password;
                this.portString = base.portString;
                this.host = base.host;
                this.nonProxyHosts = base.nonProxyHosts;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activeString(String activeString) {
            this.activeString = activeString;
            return this;
        }

        @Nonnull
        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder portString(String portString) {
            this.portString = portString;
            return this;
        }

        @Nonnull
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Nonnull
        public Builder nonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Proxy build() {
            if (base != null
                    && (id == null || id == base.id)
                    && (activeString == null || activeString == base.activeString)
                    && (protocol == null || protocol == base.protocol)
                    && (username == null || username == base.username)
                    && (password == null || password == base.password)
                    && (portString == null || portString == base.portString)
                    && (host == null || host == base.host)
                    && (nonProxyHosts == null || nonProxyHosts == base.nonProxyHosts)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("id", newlocs.containsKey("id") ? newlocs.get("id") : oldlocs.get("id"));
            locations.put("activeString", newlocs.containsKey("activeString") ? newlocs.get("activeString") : oldlocs.get("activeString"));
            locations.put("protocol", newlocs.containsKey("protocol") ? newlocs.get("protocol") : oldlocs.get("protocol"));
            locations.put("username", newlocs.containsKey("username") ? newlocs.get("username") : oldlocs.get("username"));
            locations.put("password", newlocs.containsKey("password") ? newlocs.get("password") : oldlocs.get("password"));
            locations.put("portString", newlocs.containsKey("portString") ? newlocs.get("portString") : oldlocs.get("portString"));
            locations.put("host", newlocs.containsKey("host") ? newlocs.get("host") : oldlocs.get("host"));
            locations.put("nonProxyHosts", newlocs.containsKey("nonProxyHosts") ? newlocs.get("nonProxyHosts") : oldlocs.get("nonProxyHosts"));
            return new Proxy(
                id != null ? id : (base != null ? base.id : null),
                activeString != null ? activeString : (base != null ? base.activeString : null),
                protocol != null ? protocol : (base != null ? base.protocol : null),
                username != null ? username : (base != null ? base.username : null),
                password != null ? password : (base != null ? base.password : null),
                portString != null ? portString : (base != null ? base.portString : null),
                host != null ? host : (base != null ? base.host : null),
                nonProxyHosts != null ? nonProxyHosts : (base != null ? base.nonProxyHosts : null),
                locations
            );
        }
    }


    /**
     * Indicates if this proxy is active.
     * To allow interpolation of this field, this method lazily parses
     * the {@link #getActiveString()} value as a boolean and defaults to {@code true}
     * if not set.
     *
     * @return a boolean indicating if this proxy is active
     */
    public boolean isActive() {
        return (getActiveString() != null) ? Boolean.parseBoolean(getActiveString()) : true;
    }

    /**
     * Returns the port to use for this proxy.
     * To allow interpolation of this field, this method lazily parses
     * the {@link #getPortString()} value as an integer and defaults to {@code 8080}
     * if not set.
     *
     * @return an integer indicating the port to use for this proxy
     */
    public int getPort() {
        return (getPortString() != null) ? Integer.parseInt(getPortString()) : 8080;
    }

          
}
