/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ActivationOS
implements Serializable,
InputLocationTracker {
    final String name;
    final String family;
    final String arch;
    final String version;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected ActivationOS(Builder builder) {
        String string = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string2 = builder.family != null ? builder.family : (this.family = builder.base != null ? builder.base.family : null);
        String string3 = builder.arch != null ? builder.arch : (this.arch = builder.base != null ? builder.base.arch : null);
        this.version = builder.version != null ? builder.version : (builder.base != null ? builder.base.version : null);
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
        mutableLocations.put("family", newlocs.containsKey("family") ? (InputLocation)newlocs.get("family") : (InputLocation)oldlocs.get("family"));
        mutableLocations.put("arch", newlocs.containsKey("arch") ? (InputLocation)newlocs.get("arch") : (InputLocation)oldlocs.get("arch"));
        mutableLocations.put("version", newlocs.containsKey("version") ? (InputLocation)newlocs.get("version") : (InputLocation)oldlocs.get("version"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return ActivationOS.newBuilder(this);
    }

    @Nonnull
    public ActivationOS withName(String name) {
        return ActivationOS.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public ActivationOS withFamily(String family) {
        return ActivationOS.newBuilder(this, true).family(family).build();
    }

    @Nonnull
    public ActivationOS withArch(String arch) {
        return ActivationOS.newBuilder(this, true).arch(arch).build();
    }

    @Nonnull
    public ActivationOS withVersion(String version) {
        return ActivationOS.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public static ActivationOS newInstance() {
        return ActivationOS.newInstance(true);
    }

    @Nonnull
    public static ActivationOS newInstance(boolean withDefaults) {
        return ActivationOS.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ActivationOS.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ActivationOS from) {
        return ActivationOS.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ActivationOS from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        ActivationOS base;
        String name;
        String family;
        String arch;
        String version;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(ActivationOS base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.family = base.family;
                this.arch = base.arch;
                this.version = base.version;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder family(String family) {
            this.family = family;
            return this;
        }

        @Nonnull
        public Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ActivationOS build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.family != null && this.family != this.base.family || this.arch != null && this.arch != this.base.arch || this.version != null && this.version != this.base.version)) {
                return this.base;
            }
            return new ActivationOS(this);
        }
    }
}

