// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Modifications to the build process which is keyed on some sort of environmental parameter.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Profile
    extends IdentifiableBase
    implements Serializable, InputLocationTracker
{
    /**
     * The conditional logic which will automatically trigger the inclusion of this profile.
     */
    final Activation activation;
    /**
     * Extended configuration specific to this profile goes here.
     * Contents take the form of {@code <property.name>property.value</property.name>}
     */
    final Map<String, String> properties;
    /**
     * The lists of the remote repositories.
     */
    final List<Repository> repositories;
    /**
     * The lists of the remote repositories for discovering plugins.
     */
    final List<Repository> pluginRepositories;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Profile(Builder builder) {
        super(builder);
        this.activation = builder.activation != null ? builder.activation : (builder.base != null ? builder.base.activation : null);
        this.properties = ImmutableCollections.copy(builder.properties != null ? builder.properties : (builder.base != null ? builder.base.properties : null));
        this.repositories = ImmutableCollections.copy(builder.repositories != null ? builder.repositories : (builder.base != null ? builder.base.repositories : null));
        this.pluginRepositories = ImmutableCollections.copy(builder.pluginRepositories != null ? builder.pluginRepositories : (builder.base != null ? builder.base.pluginRepositories : null));
    }

    /**
     * The conditional logic which will automatically trigger the inclusion of this profile.
     *
     * @return a {@code Activation}
     */
    public Activation getActivation() {
        return this.activation;
    }

    /**
     * Extended configuration specific to this profile goes here.
     * Contents take the form of {@code <property.name>property.value</property.name>}
     *
     * @return a {@code Map<String, String>}
     */
    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    /**
     * The lists of the remote repositories.
     *
     * @return a {@code List<Repository>}
     */
    @Nonnull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    /**
     * The lists of the remote repositories for discovering plugins.
     *
     * @return a {@code List<Repository>}
     */
    @Nonnull
    public List<Repository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Profile} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Profile} with the specified id
     */
    @Nonnull
    public Profile withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified activation.
     *
     * @param activation the new {@code Activation} to use
     * @return a {@code Profile} with the specified activation
     */
    @Nonnull
    public Profile withActivation(Activation activation) {
        return newBuilder(this, true).activation(activation).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Profile} with the specified properties
     */
    @Nonnull
    public Profile withProperties(Map<String, String> properties) {
        return newBuilder(this, true).properties(properties).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code Profile} with the specified repositories
     */
    @Nonnull
    public Profile withRepositories(Collection<Repository> repositories) {
        return newBuilder(this, true).repositories(repositories).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code Profile} with the specified pluginRepositories
     */
    @Nonnull
    public Profile withPluginRepositories(Collection<Repository> pluginRepositories) {
        return newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }

    /**
     * Creates a new {@code Profile} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Profile}
     */
    @Nonnull
    public static Profile newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Profile} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Profile}
     */
    @Nonnull
    public static Profile newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Profile} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Profile} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Profile} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Profile} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Profile from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Profile} builder instance using the specified object as a basis.
     *
     * @param from the {@code Profile} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Profile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Profile instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends IdentifiableBase.Builder
    {
        Profile base;
        Activation activation;
        Map<String, String> properties;
        Collection<Repository> repositories;
        Collection<Repository> pluginRepositories;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        protected Builder(Profile base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.activation = base.activation;
                this.properties = base.properties;
                this.repositories = base.repositories;
                this.pluginRepositories = base.pluginRepositories;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activation(Activation activation) {
            this.activation = activation;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Profile build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
                    && (activation == null || activation == base.activation)
                    && (properties == null || properties == base.properties)
                    && (repositories == null || repositories == base.repositories)
                    && (pluginRepositories == null || pluginRepositories == base.pluginRepositories)
            ) {
                return base;
            }
            return new Profile(this);
        }

    }

}
