// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Base class for {@code Mirror}, {@code Profile}, {@code Proxy} and {@code Server}.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class IdentifiableBase
    extends TrackableBase
    implements Serializable, InputLocationTracker
{
    /**
     * Item identifier.
     */
    final String id;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected IdentifiableBase(Builder builder) {
        super(builder);
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
    }

    /**
     * Item identifier.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code IdentifiableBase} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code IdentifiableBase} with the specified id
     */
    @Nonnull
    public IdentifiableBase withId(String id) {
        return newBuilder(this, true).id(id).build();
    }

    /**
     * Creates a new {@code IdentifiableBase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code IdentifiableBase}
     */
    @Nonnull
    public static IdentifiableBase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code IdentifiableBase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code IdentifiableBase}
     */
    @Nonnull
    public static IdentifiableBase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code IdentifiableBase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code IdentifiableBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code IdentifiableBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code IdentifiableBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(IdentifiableBase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code IdentifiableBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code IdentifiableBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(IdentifiableBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create IdentifiableBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends TrackableBase.Builder
    {
        IdentifiableBase base;
        String id;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        protected Builder(IdentifiableBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public IdentifiableBase build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
            ) {
                return base;
            }
            return new IdentifiableBase(this);
        }

    }

}
