// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Repository contains the information needed
 * for establishing connections with remote repository
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryBase
    extends IdentifiableBase
    implements Serializable, InputLocationTracker
{
    /**
     * Human readable name of the repository.
     */
    final String name;
    /**
     * The url of the repository.
     */
    final String url;
    /**
     * The type of layout this repository uses for locating and
     * storing artifacts - can be "legacy" or "default".
     */
    final String layout;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected RepositoryBase(Builder builder) {
        super(builder);
        this.name = builder.name != null ? builder.name : (builder.base != null ? builder.base.name : null);
        this.url = builder.url != null ? builder.url : (builder.base != null ? builder.base.url : null);
        this.layout = builder.layout != null ? builder.layout : (builder.base != null ? builder.base.layout : null);
    }

    /**
     * Human readable name of the repository.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The url of the repository.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * The type of layout this repository uses for locating and
     * storing artifacts - can be "legacy" or "default".
     *
     * @return a {@code String}
     */
    public String getLayout() {
        return this.layout;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified id
     */
    @Nonnull
    public RepositoryBase withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified name
     */
    @Nonnull
    public RepositoryBase withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified url
     */
    @Nonnull
    public RepositoryBase withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified layout.
     *
     * @param layout the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified layout
     */
    @Nonnull
    public RepositoryBase withLayout(String layout) {
        return newBuilder(this, true).layout(layout).build();
    }

    /**
     * Creates a new {@code RepositoryBase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryBase}
     */
    @Nonnull
    public static RepositoryBase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code RepositoryBase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryBase}
     */
    @Nonnull
    public static RepositoryBase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code RepositoryBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(RepositoryBase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(RepositoryBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create RepositoryBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends IdentifiableBase.Builder
    {
        RepositoryBase base;
        String name;
        String url;
        String layout;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.layout = "default";
            }
        }

        protected Builder(RepositoryBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public RepositoryBase build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
                    && (name == null || name == base.name)
                    && (url == null || url == base.url)
                    && (layout == null || layout == base.layout)
            ) {
                return base;
            }
            return new RepositoryBase(this);
        }

    }

}
