// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <toolchains>} element is the root of the descriptor.
 * The following table lists all the possible child elements.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PersistedToolchains
    extends TrackableBase
    implements Serializable, InputLocationTracker
{
    final String namespaceUri;
    final String modelEncoding;
    /**
     * The toolchain instance definition.
     */
    final List<ToolchainModel> toolchains;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    PersistedToolchains(
        String namespaceUri,
        String modelEncoding,
        Collection<ToolchainModel> toolchains,
        Map<Object, InputLocation> locations
    ) {
        super(
            locations
        );
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.toolchains = ImmutableCollections.copy(toolchains);
    }

    public String getNamespaceUri() {
        return namespaceUri;
    }

    public String getModelEncoding() {
        return modelEncoding;
    }

    /**
     * The toolchain instance definition.
     *
     * @return a {@code List<ToolchainModel>}
     */
    @Nonnull
    public List<ToolchainModel> getToolchains() {
        return this.toolchains;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PersistedToolchains} instance using the specified toolchains.
     *
     * @param toolchains the new {@code Collection<ToolchainModel>} to use
     * @return a {@code PersistedToolchains} with the specified toolchains
     */
    @Nonnull
    public PersistedToolchains withToolchains(Collection<ToolchainModel> toolchains) {
        return newBuilder(this, true).toolchains(toolchains).build();
    }

    /**
     * Creates a new {@code PersistedToolchains} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PersistedToolchains}
     */
    @Nonnull
    public static PersistedToolchains newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PersistedToolchains} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PersistedToolchains}
     */
    @Nonnull
    public static PersistedToolchains newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PersistedToolchains} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PersistedToolchains from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance using the specified object as a basis.
     *
     * @param from the {@code PersistedToolchains} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PersistedToolchains from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PersistedToolchains instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends TrackableBase.Builder
    {
        PersistedToolchains base;
        String namespaceUri;
        String modelEncoding;
        Collection<ToolchainModel> toolchains;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        Builder(PersistedToolchains base, boolean forceCopy) {
            super(base, forceCopy);
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.toolchains = base.toolchains;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder toolchains(Collection<ToolchainModel> toolchains) {
            this.toolchains = toolchains;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PersistedToolchains build() {
            if (base != null
                    && (toolchains == null || toolchains == base.toolchains)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("toolchains", newlocs.containsKey("toolchains") ? newlocs.get("toolchains") : oldlocs.get("toolchains"));
            return new PersistedToolchains(
                namespaceUri != null ? namespaceUri : (base != null ? base.namespaceUri : ""),
                modelEncoding != null ? modelEncoding : (base != null ? base.modelEncoding : "UTF-8"),
                toolchains != null ? toolchains : (base != null ? base.toolchains : null),
                locations
            );
        }
    }

}
