/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.toolchain.ImmutableCollections;
import org.apache.maven.api.toolchain.InputLocation;
import org.apache.maven.api.toolchain.InputLocationTracker;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PersistedToolchains
extends TrackableBase
implements Serializable,
InputLocationTracker {
    final String namespaceUri;
    final String modelEncoding;
    final List<ToolchainModel> toolchains;

    PersistedToolchains(String namespaceUri, String modelEncoding, Collection<ToolchainModel> toolchains, Map<Object, InputLocation> locations) {
        super(locations);
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.toolchains = ImmutableCollections.copy(toolchains);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Nonnull
    public List<ToolchainModel> getToolchains() {
        return this.toolchains;
    }

    @Override
    @Nonnull
    public Builder with() {
        return PersistedToolchains.newBuilder(this);
    }

    @Nonnull
    public PersistedToolchains withToolchains(Collection<ToolchainModel> toolchains) {
        return PersistedToolchains.newBuilder(this, true).toolchains(toolchains).build();
    }

    @Nonnull
    public static PersistedToolchains newInstance() {
        return PersistedToolchains.newInstance(true);
    }

    @Nonnull
    public static PersistedToolchains newInstance(boolean withDefaults) {
        return PersistedToolchains.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PersistedToolchains.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PersistedToolchains from) {
        return PersistedToolchains.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PersistedToolchains from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        PersistedToolchains base;
        String namespaceUri;
        String modelEncoding;
        Collection<ToolchainModel> toolchains;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PersistedToolchains base, boolean forceCopy) {
            super(base, forceCopy);
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.toolchains = base.toolchains;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder toolchains(Collection<ToolchainModel> toolchains) {
            this.toolchains = toolchains;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public PersistedToolchains build() {
            if (this.base != null && (this.toolchains == null || this.toolchains == this.base.toolchains)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("toolchains", newlocs.containsKey("toolchains") ? (InputLocation)newlocs.get("toolchains") : (InputLocation)oldlocs.get("toolchains"));
            return new PersistedToolchains(this.namespaceUri != null ? this.namespaceUri : (this.base != null ? this.base.namespaceUri : ""), this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.toolchains != null ? this.toolchains : (this.base != null ? this.base.toolchains : null), locations);
        }
    }
}

