/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public class MavenArchiver {
    public static final String SIMPLE_LAYOUT = "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String SIMPLE_LAYOUT_NONUNIQUE = "${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT_NONUNIQUE = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    private static final List<String> ARTIFACT_EXPRESSION_PREFIXES;
    private JarArchiver archiver;
    private File archiveFile;

    static boolean isValidModuleName(String name) {
        return SourceVersion.isName(name);
    }

    public Manifest getManifest(MavenSession session, MavenProject project, MavenArchiveConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        boolean hasManifestEntries = !config.isManifestEntriesEmpty();
        Map<String, String> entries = hasManifestEntries ? config.getManifestEntries() : Collections.emptyMap();
        Manifest manifest = this.getManifest(session, project, config.getManifest(), entries);
        if (hasManifestEntries) {
            for (Map.Entry entry : entries.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Manifest.ExistingAttribute attr = manifest.getMainSection().getAttribute(key);
                if (key.equals("ClassPath") && attr != null) {
                    attr.setValue(value + " " + attr.getValue());
                    continue;
                }
                this.addManifestAttribute(manifest, key, value);
            }
        }
        if (!config.isManifestSectionsEmpty()) {
            for (ManifestSection manifestSection : config.getManifestSections()) {
                Manifest.Section theSection = new Manifest.Section();
                theSection.setName(manifestSection.getName());
                if (!manifestSection.isManifestEntriesEmpty()) {
                    Map<String, String> sectionEntries = manifestSection.getManifestEntries();
                    for (Map.Entry<String, String> entry : sectionEntries.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        Manifest.Attribute attr = new Manifest.Attribute(key, value);
                        theSection.addConfiguredAttribute(attr);
                    }
                }
                manifest.addConfiguredSection(theSection);
            }
        }
        return manifest;
    }

    public Manifest getManifest(MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        return this.getManifest(null, project, config, Collections.emptyMap());
    }

    public Manifest getManifest(MavenSession mavenSession, MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        return this.getManifest(mavenSession, project, config, Collections.emptyMap());
    }

    private void addManifestAttribute(Manifest manifest, Map<String, String> map, String key, String value) throws ManifestException {
        if (map.containsKey(key)) {
            return;
        }
        this.addManifestAttribute(manifest, key, value);
    }

    private void addManifestAttribute(Manifest manifest, String key, String value) throws ManifestException {
        if (!StringUtils.isEmpty((String)value)) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value);
            manifest.addConfiguredAttribute(attr);
        } else {
            Manifest.Attribute attr = new Manifest.Attribute(key, "");
            manifest.addConfiguredAttribute(attr);
        }
    }

    protected Manifest getManifest(MavenSession session, MavenProject project, ManifestConfiguration config, Map<String, String> entries) throws ManifestException, DependencyResolutionRequiredException {
        String mainClass;
        Manifest m = new Manifest();
        this.addCreatedByEntry(session, m, entries);
        this.addCustomEntries(m, entries, config);
        if (config.isAddClasspath()) {
            StringBuilder classpath = new StringBuilder();
            List artifacts = project.getRuntimeClasspathElements();
            String classpathPrefix = config.getClasspathPrefix();
            String layoutType = config.getClasspathLayoutType();
            String layout = config.getCustomClasspathLayout();
            StringSearchInterpolator interpolator = new StringSearchInterpolator();
            for (String artifactFile : artifacts) {
                File f = new File(artifactFile);
                if (!f.getAbsoluteFile().isFile()) continue;
                Artifact artifact = this.findArtifactWithFile(project.getArtifacts(), f);
                if (classpath.length() > 0) {
                    classpath.append(" ");
                }
                classpath.append(classpathPrefix);
                if (artifact == null || layoutType == null) {
                    classpath.append(f.getName());
                    continue;
                }
                ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>();
                this.handleExtraExpression(artifact, valueSources);
                for (ValueSource valueSource : valueSources) {
                    interpolator.addValueSource(valueSource);
                }
                PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(ARTIFACT_EXPRESSION_PREFIXES);
                try {
                    if ("simple".equals(layoutType)) {
                        if (config.isUseUniqueVersions()) {
                            classpath.append(interpolator.interpolate(SIMPLE_LAYOUT, (RecursionInterceptor)recursionInterceptor));
                            continue;
                        }
                        classpath.append(interpolator.interpolate(SIMPLE_LAYOUT_NONUNIQUE, (RecursionInterceptor)recursionInterceptor));
                        continue;
                    }
                    if ("repository".equals(layoutType)) {
                        if (config.isUseUniqueVersions()) {
                            classpath.append(interpolator.interpolate(REPOSITORY_LAYOUT, (RecursionInterceptor)recursionInterceptor));
                            continue;
                        }
                        classpath.append(interpolator.interpolate(REPOSITORY_LAYOUT_NONUNIQUE, (RecursionInterceptor)recursionInterceptor));
                        continue;
                    }
                    if ("custom".equals(layoutType)) {
                        if (layout == null) {
                            throw new ManifestException("custom layout type was declared, but custom layout expression was not specified. Check your <archive><manifest><customLayout/> element.");
                        }
                        classpath.append(interpolator.interpolate(layout, (RecursionInterceptor)recursionInterceptor));
                        continue;
                    }
                    throw new ManifestException("Unknown classpath layout type: '" + layoutType + "'. Check your <archive><manifest><layoutType/> element.");
                }
                catch (InterpolationException interpolationException) {
                    ManifestException error = new ManifestException("Error interpolating artifact path for classpath entry: " + interpolationException.getMessage());
                    error.initCause((Throwable)interpolationException);
                    throw error;
                }
                finally {
                    for (ValueSource vs : valueSources) {
                        interpolator.removeValuesSource(vs);
                    }
                }
            }
            if (classpath.length() > 0) {
                this.addManifestAttribute(m, "Class-Path", classpath.toString());
            }
        }
        if (config.isAddDefaultSpecificationEntries()) {
            this.handleSpecificationEntries(project, entries, m);
        }
        if (config.isAddDefaultImplementationEntries()) {
            this.handleImplementationEntries(project, entries, m);
        }
        if ((mainClass = config.getMainClass()) != null && !"".equals(mainClass)) {
            this.addManifestAttribute(m, entries, "Main-Class", mainClass);
        }
        if (config.isAddExtensions()) {
            this.handleExtensions(project, entries, m);
        }
        return m;
    }

    private void handleExtraExpression(Artifact artifact, List<ValueSource> valueSources) {
        valueSources.add((ValueSource)new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)artifact, true));
        valueSources.add((ValueSource)new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)artifact.getArtifactHandler(), true));
        Properties extraExpressions = new Properties();
        if (!artifact.isSnapshot()) {
            extraExpressions.setProperty("baseVersion", artifact.getVersion());
        }
        extraExpressions.setProperty("groupIdPath", artifact.getGroupId().replace('.', '/'));
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            extraExpressions.setProperty("dashClassifier", "-" + artifact.getClassifier());
            extraExpressions.setProperty("dashClassifier?", "-" + artifact.getClassifier());
        } else {
            extraExpressions.setProperty("dashClassifier", "");
            extraExpressions.setProperty("dashClassifier?", "");
        }
        valueSources.add((ValueSource)new PrefixedPropertiesValueSource(ARTIFACT_EXPRESSION_PREFIXES, extraExpressions, true));
    }

    private void handleExtensions(MavenProject project, Map<String, String> entries, Manifest m) throws ManifestException {
        StringBuilder extensionsList = new StringBuilder();
        Set artifacts = project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if ("test".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            if (extensionsList.length() > 0) {
                extensionsList.append(" ");
            }
            extensionsList.append(artifact.getArtifactId());
        }
        if (extensionsList.length() > 0) {
            this.addManifestAttribute(m, entries, "Extension-List", extensionsList.toString());
        }
        for (Object artifact1 : artifacts) {
            Artifact artifact = (Artifact)artifact1;
            if (!"jar".equals(artifact.getType())) continue;
            String artifactId = artifact.getArtifactId().replace('.', '_');
            String ename = artifactId + "-Extension-Name";
            this.addManifestAttribute(m, entries, ename, artifact.getArtifactId());
            String iname = artifactId + "-Implementation-Version";
            this.addManifestAttribute(m, entries, iname, artifact.getVersion());
            if (artifact.getRepository() == null) continue;
            iname = artifactId + "-Implementation-URL";
            String url = artifact.getRepository().getUrl() + "/" + artifact.toString();
            this.addManifestAttribute(m, entries, iname, url);
        }
    }

    private void handleImplementationEntries(MavenProject project, Map<String, String> entries, Manifest m) throws ManifestException {
        this.addManifestAttribute(m, entries, "Implementation-Title", project.getName());
        this.addManifestAttribute(m, entries, "Implementation-Version", project.getVersion());
        this.addManifestAttribute(m, entries, "Implementation-Vendor-Id", project.getGroupId());
        if (project.getOrganization() != null) {
            this.addManifestAttribute(m, entries, "Implementation-Vendor", project.getOrganization().getName());
        }
        if (project.getUrl() != null) {
            this.addManifestAttribute(m, entries, "Implementation-URL", project.getUrl());
        }
    }

    private void handleSpecificationEntries(MavenProject project, Map<String, String> entries, Manifest m) throws ManifestException {
        this.addManifestAttribute(m, entries, "Specification-Title", project.getName());
        try {
            ArtifactVersion version = project.getArtifact().getSelectedVersion();
            String specVersion = String.format("%s.%s", version.getMajorVersion(), version.getMinorVersion());
            this.addManifestAttribute(m, entries, "Specification-Version", specVersion);
        }
        catch (OverConstrainedVersionException e) {
            throw new ManifestException("Failed to get selected artifact version to calculate the specification version: " + e.getMessage());
        }
        if (project.getOrganization() != null) {
            this.addManifestAttribute(m, entries, "Specification-Vendor", project.getOrganization().getName());
        }
    }

    private void addCustomEntries(Manifest m, Map<String, String> entries, ManifestConfiguration config) throws ManifestException {
        this.addManifestAttribute(m, entries, "Built-By", System.getProperty("user.name"));
        this.addManifestAttribute(m, entries, "Build-Jdk", System.getProperty("java.version"));
        if (config.getPackageName() != null) {
            this.addManifestAttribute(m, entries, "Package", config.getPackageName());
        }
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(MavenSession session, MavenProject project, MavenArchiveConfiguration archiveConfiguration) throws ManifestException, IOException, DependencyResolutionRequiredException {
        String automaticModuleName;
        File manifestFile;
        MavenProject workingProject = null;
        workingProject = project.clone();
        boolean forced = archiveConfiguration.isForced();
        if (archiveConfiguration.isAddMavenDescriptor()) {
            if (workingProject.getArtifact().isSnapshot()) {
                workingProject.setVersion(workingProject.getArtifact().getVersion());
            }
            String groupId = workingProject.getGroupId();
            String artifactId = workingProject.getArtifactId();
            this.archiver.addFile(project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            File customPomPropertiesFile = archiveConfiguration.getPomPropertiesFile();
            File dir = new File(workingProject.getBuild().getDirectory(), "maven-archiver");
            File pomPropertiesFile = new File(dir, "pom.properties");
            new PomPropertiesUtil().createPomProperties(session, workingProject, (Archiver)this.archiver, customPomPropertiesFile, pomPropertiesFile, forced);
        }
        if ((manifestFile = archiveConfiguration.getManifestFile()) != null) {
            this.archiver.setManifest(manifestFile);
        }
        Manifest manifest = this.getManifest(session, workingProject, archiveConfiguration);
        this.archiver.addConfiguredManifest(manifest);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setRecompressAddedZips(archiveConfiguration.isRecompressAddedZips());
        this.archiver.setIndex(archiveConfiguration.isIndex());
        this.archiver.setDestFile(this.archiveFile);
        if (archiveConfiguration.getManifest().isAddClasspath()) {
            List artifacts = project.getRuntimeClasspathElements();
            for (String artifact : artifacts) {
                File f = new File(artifact);
                this.archiver.addConfiguredIndexJars(f);
            }
        }
        this.archiver.setForced(forced);
        if (archiveConfiguration.isForced() || this.archiver.isSupportingForced()) {
            // empty if block
        }
        if ((automaticModuleName = manifest.getMainSection().getAttributeValue("Automatic-Module-Name")) != null && !MavenArchiver.isValidModuleName(automaticModuleName)) {
            throw new ManifestException("Invalid automatic module name: '" + automaticModuleName + "'");
        }
        this.archiver.createArchive();
    }

    private void addCreatedByEntry(MavenSession session, Manifest m, Map<String, String> entries) throws ManifestException {
        String mavenVersion;
        String createdBy = "Apache Maven";
        if (session != null && (mavenVersion = session.getSystemProperties().getProperty("maven.version")) != null) {
            createdBy = createdBy + " " + mavenVersion;
        }
        this.addManifestAttribute(m, entries, "Created-By", createdBy);
    }

    private Artifact findArtifactWithFile(Set<Artifact> artifacts, File file) {
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || !artifact.getFile().equals(file)) continue;
            return artifact;
        }
        return null;
    }

    static {
        ArrayList<String> artifactExpressionPrefixes = new ArrayList<String>();
        artifactExpressionPrefixes.add("artifact.");
        ARTIFACT_EXPRESSION_PREFIXES = artifactExpressionPrefixes;
    }
}

