/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends AbstractArtifactTask {
    private RemoteRepository remoteRepository;
    private File file;

    public void execute() {
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder builder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        Pom pom = this.buildPom(builder, localRepo);
        if (pom == null) {
            throw new BuildException("A POM element is required to deploy to the repository");
        }
        if (this.remoteRepository == null) {
            if (pom.getDistributionManagement() == null || pom.getDistributionManagement().getRepository() == null) {
                throw new BuildException("A distributionManagement element is required in your POM to deploy");
            }
            this.remoteRepository = this.createAntRemoteRepository(pom.getDistributionManagement().getRepository());
        }
        ArtifactRepository deploymentRepository = this.createRemoteArtifactRepository(this.remoteRepository);
        Artifact artifact = this.createArtifact(pom);
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        this.log("Deploying to " + this.remoteRepository.getUrl());
        ArtifactDeployer deployer = (ArtifactDeployer)this.lookup(ArtifactDeployer.ROLE);
        try {
            if (!isPomArtifact) {
                deployer.deploy(this.file, artifact, deploymentRepository, localRepo);
            } else {
                deployer.deploy(pom.getFile(), artifact, deploymentRepository, localRepo);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new BuildException("Error deploying artifact", (Throwable)e);
        }
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepository = remoteRepository;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

