/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.tools.ant.Project;

public class AntResolutionListener
implements ResolutionListener {
    private String indent = "";
    private final Project project;

    public AntResolutionListener(Project project) {
        this.project = project;
    }

    public void testArtifact(Artifact node) {
    }

    public void startProcessChildren(Artifact artifact) {
        this.indent = this.indent + "  ";
    }

    public void endProcessChildren(Artifact artifact) {
        this.indent = this.indent.substring(2);
    }

    public void includeArtifact(Artifact artifact) {
        this.project.log(this.indent + artifact.getId() + " (selected)");
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        this.project.log(this.indent + omitted.getId() + " (removed - nearer found: " + kept.getVersion() + ")");
    }

    public void omitForCycle(Artifact omitted) {
        this.project.log(this.indent + omitted.getId() + " (removed - causes a cycle in the graph)");
    }

    public void updateScope(Artifact artifact, String scope) {
        this.project.log(this.indent + artifact.getId() + " (setting scope to: " + scope + ")");
    }

    public void updateScopeCurrentPom(Artifact artifact, String scope) {
        this.updateScope(artifact, scope);
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.project.log(this.indent + artifact.getId() + " (setting version to: " + artifact.getVersion() + " from range: " + artifact.getVersionRange() + ")");
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        String msg = this.indent + artifact.getId();
        msg = msg + " (";
        if (replacement.getVersion() != null) {
            msg = msg + "applying version: " + replacement.getVersion() + ";";
        }
        if (replacement.getScope() != null) {
            msg = msg + "applying scope: " + replacement.getScope();
        }
        msg = msg + ")";
        this.project.log(msg);
    }
}

