/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.codehaus.plexus.PlexusContainerException;

public class InstallWagonProviderTask
extends AbstractArtifactTask {
    private String artifactId;
    private String version;

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void execute() throws BuildException {
        MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        ArtifactRepository artifactRepository = this.createRemoteArtifactRepository(AbstractArtifactTask.getDefaultRemoteRepository());
        List<ArtifactRepository> remoteRepositories = Collections.singletonList(artifactRepository);
        try {
            ArtifactFactory factory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)this.version);
            Artifact providerArtifact = factory.createExtensionArtifact("org.apache.maven.wagon", this.artifactId, versionRange);
            ArtifactResolutionResult result = resolver.resolveTransitively(Collections.singleton(providerArtifact), this.createArtifact(this.createDummyPom()), this.createLocalArtifactRepository(), remoteRepositories, (ArtifactMetadataSource)metadataSource, null);
            this.log("Installing provider: " + providerArtifact);
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                this.getEmbedder().getContainer().addJarResource(a.getFile());
            }
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to locate wagon provider in remote repository", (Throwable)e);
        }
        catch (PlexusContainerException e) {
            throw new BuildException("Unable to locate wagon provider in remote repository", (Throwable)e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new BuildException("Unable to locate wagon provider in remote repository", (Throwable)e);
        }
    }
}

