/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractRepositoryMetadata
implements RepositoryMetadata {
    private Metadata metadata;

    protected AbstractRepositoryMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getRemoteFilename() {
        return "maven-metadata.xml";
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return "maven-metadata-" + repository.getKey() + ".xml";
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        try {
            this.updateRepositoryMetadata(localRepository, remoteRepository);
        }
        catch (IOException e) {
            throw new ArtifactMetadataRetrievalException("Error updating group repository metadata", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ArtifactMetadataRetrievalException("Error updating group repository metadata", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRepositoryMetadata(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws IOException, XmlPullParserException {
        block8: {
            File metadataFile;
            block7: {
                MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
                Metadata metadata = null;
                metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)this, remoteRepository));
                if (metadataFile.exists()) {
                    FileReader reader = null;
                    try {
                        reader = new FileReader(metadataFile);
                        metadata = mappingReader.read((Reader)reader);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(reader);
                        throw throwable;
                    }
                    IOUtil.close((Reader)reader);
                }
                boolean changed = false;
                if (metadata == null) {
                    metadata = new Metadata();
                    metadata.setGroupId(this.getGroupId());
                    metadata.setArtifactId(this.getArtifactId());
                    metadata.setVersion(this.getBaseVersion());
                    changed = true;
                }
                if (!(changed |= metadata.merge(this.metadata))) break block7;
                FileWriter writer = null;
                try {
                    metadataFile.getParentFile().mkdirs();
                    writer = new FileWriter(metadataFile);
                    MetadataXpp3Writer mappingWriter = new MetadataXpp3Writer();
                    mappingWriter.write((Writer)writer, metadata);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close((Writer)writer);
                break block8;
            }
            metadataFile.setLastModified(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "repository metadata for: '" + this.getKey() + "'";
    }

    protected static Metadata createMetadata(Artifact artifact, Versioning versioning) {
        Metadata metadata = new Metadata();
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getVersion());
        metadata.setVersioning(versioning);
        return metadata;
    }

    protected static Versioning createVersioning(Snapshot snapshot) {
        Versioning versioning = new Versioning();
        versioning.setSnapshot(snapshot);
        return versioning;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void merge(ArtifactMetadata metadata) {
        AbstractRepositoryMetadata repoMetadata = (AbstractRepositoryMetadata)metadata;
        this.metadata.merge(repoMetadata.getMetadata());
    }

    public abstract /* synthetic */ boolean isSnapshot();

    public abstract /* synthetic */ void setRepository(ArtifactRepository var1);

    public abstract /* synthetic */ Object getKey();

    public abstract /* synthetic */ String getBaseVersion();

    public abstract /* synthetic */ String getArtifactId();

    public abstract /* synthetic */ String getGroupId();

    public abstract /* synthetic */ boolean storedInGroupDirectory();

    public abstract /* synthetic */ boolean storedInArtifactVersionDirectory();
}

