/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultRepositoryMetadataManager
extends AbstractLogEnabled
implements RepositoryMetadataManager {
    private WagonManager wagonManager;
    private Set cachedMetadata = new HashSet();

    public void resolve(RepositoryMetadata metadata, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryPolicy policy;
        ArtifactRepository repository;
        Iterator i;
        boolean alreadyResolved = this.alreadyResolved(metadata);
        if (!alreadyResolved) {
            i = remoteRepositories.iterator();
            while (i.hasNext()) {
                repository = (ArtifactRepository)i.next();
                ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
                if (!policy.isEnabled()) {
                    this.getLogger().debug("Skipping disabled repository " + repository.getId());
                    continue;
                }
                File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, repository));
                boolean checkForUpdates = policy.checkOutOfDate(new Date(file.lastModified()));
                if (checkForUpdates) {
                    this.getLogger().info(metadata.getKey() + ": checking for updates from " + repository.getId());
                    this.resolveAlways(metadata, repository, file, policy.getChecksumPolicy());
                }
                if (file.exists()) {
                    file.setLastModified(System.currentTimeMillis());
                    continue;
                }
                metadata.storeInLocalRepository(localRepository, repository);
            }
            this.cachedMetadata.add(metadata.getKey());
        }
        this.loadMetadata(metadata, localRepository, localRepository);
        i = remoteRepositories.iterator();
        while (i.hasNext()) {
            repository = (ArtifactRepository)i.next();
            policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
            if (!policy.isEnabled()) continue;
            this.loadMetadata(metadata, repository, localRepository);
        }
    }

    private void loadMetadata(RepositoryMetadata repoMetadata, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)repoMetadata, remoteRepository));
        if (metadataFile.exists()) {
            Metadata metadata = DefaultRepositoryMetadataManager.readMetadata(metadataFile);
            if (repoMetadata.getMetadata() != null && !metadata.merge(repoMetadata.getMetadata())) {
                repoMetadata.setRepository(remoteRepository);
            }
            repoMetadata.setMetadata(metadata);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Metadata readMetadata(File mappingFile) throws ArtifactMetadataRetrievalException {
        Metadata result;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(mappingFile);
            MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
            result = mappingReader.read((Reader)fileReader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ArtifactMetadataRetrievalException("Cannot read version information from: " + mappingFile, (Throwable)e);
                catch (IOException e2) {
                    throw new ArtifactMetadataRetrievalException("Cannot read version information from: " + mappingFile, (Throwable)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ArtifactMetadataRetrievalException("Cannot parse version information from: " + mappingFile, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fileReader);
        return result;
    }

    public void resolveAlways(RepositoryMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, remoteRepository));
        this.resolveAlways(metadata, remoteRepository, file, "warn");
        if (file.exists()) {
            Metadata prevMetadata = DefaultRepositoryMetadataManager.readMetadata(file);
            metadata.setMetadata(prevMetadata);
        }
    }

    private void resolveAlways(ArtifactMetadata metadata, ArtifactRepository repository, File file, String checksumPolicy) throws ArtifactMetadataRetrievalException {
        try {
            this.wagonManager.getArtifactMetadata(metadata, repository, file, checksumPolicy);
        }
        catch (ResourceDoesNotExistException e) {
            this.getLogger().debug(metadata + " could not be found on repository: " + repository.getId());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (TransferFailedException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", (Throwable)e);
        }
    }

    private boolean alreadyResolved(ArtifactMetadata metadata) {
        return this.cachedMetadata.contains(metadata.getKey());
    }

    public void deploy(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws ArtifactMetadataRetrievalException {
        this.getLogger().info("Retrieving previous metadata from " + deploymentRepository.getId());
        File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, deploymentRepository));
        this.resolveAlways(metadata, deploymentRepository, file, "warn");
        metadata.storeInLocalRepository(localRepository, deploymentRepository);
        try {
            this.wagonManager.putArtifactMetadata(file, metadata, deploymentRepository);
        }
        catch (TransferFailedException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", (Throwable)e);
        }
    }

    public void install(ArtifactMetadata metadata, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        metadata.storeInLocalRepository(localRepository, localRepository);
    }
}

