/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.LegacyArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.AbstractRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractVersionTransformation
extends AbstractLogEnabled
implements ArtifactTransformation {
    protected RepositoryMetadataManager repositoryMetadataManager;
    protected WagonManager wagonManager;
    private static Set resolvedArtifactCache = new HashSet();

    protected String resolveVersion(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        AbstractRepositoryMetadata metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        this.repositoryMetadataManager.resolve(metadata, remoteRepositories, localRepository);
        Metadata repoMetadata = metadata.getMetadata();
        String version = null;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            version = this.constructVersion(repoMetadata.getVersioning(), artifact.getBaseVersion());
        }
        if (version == null && (version = this.resolveLegacyVersion(artifact, localRepository, remoteRepositories)) == null) {
            version = artifact.getBaseVersion();
        }
        if (this.getLogger().isDebugEnabled()) {
            if (!version.equals(artifact.getBaseVersion())) {
                String message = artifact.getArtifactId() + ": resolved to version " + version;
                message = artifact.getRepository() != null ? message + " from repository " + artifact.getRepository().getId() : message + " from local repository";
                this.getLogger().debug(message);
            } else {
                this.getLogger().debug(artifact.getArtifactId() + ": using locally installed snapshot");
            }
        }
        return version;
    }

    protected abstract String constructVersion(Versioning var1, String var2);

    private String resolveLegacyVersion(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        boolean alreadyResolved;
        LegacyArtifactMetadata localMetadata = this.createLegacyMetadata(artifact);
        File f = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)localMetadata, null));
        if (f.exists()) {
            try {
                localMetadata.readFromFile(f);
            }
            catch (IOException e) {
                throw new ArtifactMetadataRetrievalException("Error reading local metadata", (Throwable)e);
            }
        }
        if (!(alreadyResolved = this.alreadyResolved(artifact))) {
            boolean checkedUpdates = false;
            Iterator i = remoteRepositories.iterator();
            while (i.hasNext()) {
                ArtifactRepositoryPolicy policy;
                ArtifactRepository repository = (ArtifactRepository)i.next();
                ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = artifact.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
                if (!policy.isEnabled()) {
                    this.getLogger().debug("resolveMetaData: " + artifact.getId() + ": Skipping disabled repository " + repository.getId() + " (" + repository.getUrl() + ")");
                    continue;
                }
                boolean checkForUpdates = policy.checkOutOfDate(localMetadata.getLastModified());
                if (checkForUpdates) {
                    checkedUpdates = true;
                    try {
                        LegacyArtifactMetadata remoteMetadata = this.createLegacyMetadata(artifact);
                        remoteMetadata.retrieveFromRemoteRepository(repository, this.wagonManager, policy.getChecksumPolicy());
                        this.getLogger().warn("Using old-style versioning metadata from remote repo for " + artifact);
                        int difference = remoteMetadata.compareTo(localMetadata);
                        if (difference <= 0) continue;
                        artifact.setRepository(repository);
                        localMetadata = remoteMetadata;
                    }
                    catch (ResourceDoesNotExistException e) {
                        this.getLogger().debug("resolveMetaData: Artifact version metadata for: " + artifact.getId() + " could not be found on repository: " + repository.getId(), (Throwable)e);
                    }
                    continue;
                }
                this.getLogger().debug("resolveMetaData: " + artifact.getId() + ": NOT checking for updates from " + repository.getId() + " (" + repository.getUrl() + ")");
            }
            if (checkedUpdates && localMetadata.getLastModified().getTime() > 0L) {
                localMetadata.storeInLocalRepository(localRepository);
            }
            resolvedArtifactCache.add(AbstractVersionTransformation.getCacheKey(artifact));
        }
        if (artifact.getFile().exists() && !localMetadata.newerThanFile(artifact.getFile())) {
            if (this.getLogger().isDebugEnabled() && !alreadyResolved) {
                this.getLogger().debug(artifact.getArtifactId() + ": using locally installed snapshot");
            }
            localMetadata = null;
        }
        return localMetadata != null ? localMetadata.constructVersion() : null;
    }

    protected abstract LegacyArtifactMetadata createLegacyMetadata(Artifact var1);

    private boolean alreadyResolved(Artifact artifact) {
        return resolvedArtifactCache.contains(AbstractVersionTransformation.getCacheKey(artifact));
    }

    private static String getCacheKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    public abstract /* synthetic */ void transformForDeployment(Artifact var1, ArtifactRepository var2, ArtifactRepository var3) throws ArtifactMetadataRetrievalException;

    public abstract /* synthetic */ void transformForInstall(Artifact var1, ArtifactRepository var2) throws ArtifactMetadataRetrievalException;

    public abstract /* synthetic */ void transformForResolve(Artifact var1, List var2, ArtifactRepository var3) throws ArtifactMetadataRetrievalException;
}

