/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.LatestArtifactMetadata;
import org.apache.maven.artifact.metadata.LegacyArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.transform.AbstractVersionTransformation;

public class LatestArtifactTransformation
extends AbstractVersionTransformation {
    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        String version;
        if ("LATEST".equals(artifact.getVersion()) && (version = this.resolveVersion(artifact, localRepository, remoteRepositories)) != null && !version.equals(artifact.getVersion())) {
            artifact.setBaseVersion(version);
            artifact.updateVersion(version, localRepository);
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
    }

    protected LegacyArtifactMetadata createLegacyMetadata(Artifact artifact) {
        return new LatestArtifactMetadata(artifact);
    }

    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getLatest();
    }
}

