/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.LegacyArtifactMetadata;
import org.apache.maven.artifact.metadata.ReleaseArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.transform.AbstractVersionTransformation;

public class ReleaseArtifactTransformation
extends AbstractVersionTransformation {
    public static final String RELEASE_VERSION = "RELEASE";

    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        String version;
        if (RELEASE_VERSION.equals(artifact.getVersion()) && (version = this.resolveVersion(artifact, localRepository, remoteRepositories)) != null && !version.equals(artifact.getVersion())) {
            artifact.setBaseVersion(version);
            artifact.updateVersion(version, localRepository);
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        ArtifactMetadata metadata = this.createMetadata(artifact);
        artifact.addMetadata(metadata);
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        ArtifactMetadata metadata = this.createMetadata(artifact);
        artifact.addMetadata(metadata);
    }

    private ArtifactMetadata createMetadata(Artifact artifact) {
        Versioning versioning = new Versioning();
        versioning.addVersion(artifact.getVersion());
        if (artifact.isRelease()) {
            versioning.setRelease(artifact.getVersion());
        }
        return new ArtifactRepositoryMetadata(artifact, versioning);
    }

    protected LegacyArtifactMetadata createLegacyMetadata(Artifact artifact) {
        return new ReleaseArtifactMetadata(artifact);
    }

    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getRelease();
    }
}

