/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;

public class ResolutionNode {
    private final Artifact artifact;
    private List children;
    private final List parents;
    private final int depth;
    private final ResolutionNode parent;
    private final List remoteRepositories;

    public ResolutionNode(Artifact artifact, List remoteRepositories) {
        this.artifact = artifact;
        this.remoteRepositories = remoteRepositories;
        this.depth = 0;
        this.parents = Collections.EMPTY_LIST;
        this.parent = null;
    }

    public ResolutionNode(Artifact artifact, List remoteRepositories, ResolutionNode parent) {
        this.artifact = artifact;
        this.remoteRepositories = remoteRepositories;
        this.depth = parent.depth + 1;
        this.parents = new ArrayList();
        this.parents.addAll(parent.parents);
        this.parents.add(parent.getKey());
        this.parent = parent;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Object getKey() {
        return this.artifact.getDependencyConflictId();
    }

    public void addDependencies(Set artifacts, List remoteRepositories, ArtifactFilter filter) throws CyclicDependencyException, OverConstrainedVersionException {
        this.children = new ArrayList(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (filter != null && !filter.include(a)) continue;
            if (this.parents.contains(a.getDependencyConflictId())) {
                a.setDependencyTrail(this.getDependencyTrail());
                throw new CyclicDependencyException("A dependency has introduced a cycle", a);
            }
            this.children.add(new ResolutionNode(a, remoteRepositories, this));
        }
    }

    public List getDependencyTrail() throws OverConstrainedVersionException {
        LinkedList<String> path = new LinkedList<String>();
        ResolutionNode node = this;
        while (node != null) {
            Artifact artifact = node.getArtifact();
            if (artifact.getVersion() == null) {
                VersionRange versionRange = artifact.getVersionRange();
                String version = versionRange.getSelectedVersion().toString();
                artifact.selectVersion(version);
            }
            path.add(0, artifact.getId());
            node = node.parent;
        }
        return path;
    }

    public boolean isResolved() {
        return this.children != null;
    }

    public Iterator getChildrenIterator() {
        return this.children.iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }
}

