/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.resolver.conflict;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.repository.legacy.resolver.conflict.ConflictResolver;

@Named(value="newest")
@Singleton
public class NewestConflictResolver
implements ConflictResolver {
    @Override
    public ResolutionNode resolveConflict(ResolutionNode node1, ResolutionNode node2) {
        try {
            ArtifactVersion version1 = node1.getArtifact().getSelectedVersion();
            ArtifactVersion version2 = node2.getArtifact().getSelectedVersion();
            return version1.compareTo((Object)version2) > 0 ? node1 : node2;
        }
        catch (OverConstrainedVersionException exception) {
            return null;
        }
    }
}

