/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.resolver.transform;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.repository.legacy.resolver.transform.AbstractVersionTransformation;
import org.codehaus.plexus.util.StringUtils;

@Named(value="snapshot")
@Singleton
public class SnapshotTransformation
extends AbstractVersionTransformation {
    private static final String DEFAULT_SNAPSHOT_TIMESTAMP_FORMAT = "yyyyMMdd.HHmmss";
    private static final TimeZone DEFAULT_SNAPSHOT_TIME_ZONE = TimeZone.getTimeZone("Etc/UTC");
    private String deploymentTimestamp;

    @Override
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException {
        if (artifact.isSnapshot() && artifact.getBaseVersion().equals(artifact.getVersion())) {
            try {
                String version = this.resolveVersion(artifact, request);
                artifact.updateVersion(version, request.getLocalRepository());
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, (Throwable)e);
            }
        }
    }

    @Override
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) {
        if (artifact.isSnapshot()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setLocalCopy(true);
            SnapshotArtifactRepositoryMetadata metadata = new SnapshotArtifactRepositoryMetadata(artifact, snapshot);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
    }

    @Override
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        if (artifact.isSnapshot()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setTimestamp(this.getDeploymentTimestamp());
            try {
                int buildNumber = this.resolveLatestSnapshotBuildNumber(artifact, localRepository, remoteRepository);
                snapshot.setBuildNumber(buildNumber + 1);
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new ArtifactDeploymentException("Error retrieving previous build number for artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), e);
            }
            SnapshotArtifactRepositoryMetadata metadata = new SnapshotArtifactRepositoryMetadata(artifact, snapshot);
            artifact.setResolvedVersion(this.constructVersion(metadata.getMetadata().getVersioning(), artifact.getBaseVersion()));
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
    }

    public String getDeploymentTimestamp() {
        if (this.deploymentTimestamp == null) {
            this.deploymentTimestamp = SnapshotTransformation.getUtcDateFormatter().format(new Date());
        }
        return this.deploymentTimestamp;
    }

    @Override
    protected String constructVersion(Versioning versioning, String baseVersion) {
        String version = null;
        Snapshot snapshot = versioning.getSnapshot();
        if (snapshot != null) {
            if (snapshot.getTimestamp() != null && snapshot.getBuildNumber() > 0) {
                String newVersion = snapshot.getTimestamp() + "-" + snapshot.getBuildNumber();
                version = StringUtils.replace((String)baseVersion, (String)"SNAPSHOT", (String)newVersion);
            } else {
                version = baseVersion;
            }
        }
        return version;
    }

    private int resolveLatestSnapshotBuildNumber(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataResolutionException {
        SnapshotArtifactRepositoryMetadata metadata = new SnapshotArtifactRepositoryMetadata(artifact);
        this.getLogger().info("Retrieving previous build number from " + remoteRepository.getId());
        this.repositoryMetadataManager.resolveAlways(metadata, localRepository, remoteRepository);
        int buildNumber = 0;
        Metadata repoMetadata = metadata.getMetadata();
        if (repoMetadata != null && repoMetadata.getVersioning() != null && repoMetadata.getVersioning().getSnapshot() != null) {
            buildNumber = repoMetadata.getVersioning().getSnapshot().getBuildNumber();
        }
        return buildNumber;
    }

    public static DateFormat getUtcDateFormatter() {
        SimpleDateFormat utcDateFormatter = new SimpleDateFormat(DEFAULT_SNAPSHOT_TIMESTAMP_FORMAT);
        utcDateFormatter.setCalendar(new GregorianCalendar());
        utcDateFormatter.setTimeZone(DEFAULT_SNAPSHOT_TIME_ZONE);
        return utcDateFormatter;
    }
}

