/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.maven.BuildAbort;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.ExtensionConfigurationModule;
import org.apache.maven.cli.ResolveFile;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.cli.event.DefaultEventSpyContext;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.extension.io.CoreExtensionsStaxReader;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.cli.logging.Slf4jStdoutLogger;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.SimplexTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.ProfileActivation;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.jline.JLineMessageBuilderFactory;
import org.apache.maven.jline.MessageUtils;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.logwrapper.LogLevelRecorder;
import org.apache.maven.logwrapper.MavenSlf4jWrapperFactory;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.BasicInterpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";
    public static final String MULTIMODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "toolchains.xml");
    public static final File DEFAULT_GLOBAL_TOOLCHAINS_FILE = new File(System.getProperty("maven.conf"), "toolchains.xml");
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String EXTENSIONS_FILENAME = "extensions.xml";
    private static final String MVN_EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    public static final String STYLE_COLOR_PROPERTY = "style.color";
    private ClassWorld classWorld;
    private LoggerManager plexusLoggerManager;
    private ILoggerFactory slf4jLoggerFactory;
    private Logger slf4jLogger;
    private EventSpyDispatcher eventSpyDispatcher;
    private ModelProcessor modelProcessor;
    private Maven maven;
    private MavenExecutionRequestPopulator executionRequestPopulator;
    private ToolchainsBuilder toolchainsBuilder;
    private DefaultSecDispatcher dispatcher;
    private Map<String, ConfigurationProcessor> configurationProcessors;
    private CLIManager cliManager;
    private MessageBuilderFactory messageBuilderFactory;
    private static final Pattern NEXT_LINE = Pattern.compile("\r?\n");
    private static final Pattern LAST_ANSI_SEQUENCE = Pattern.compile("(\u001b\\[[;\\d]*[ -/]*[@-~])[^\u001b]*$");
    private static final String ANSI_RESET = "\u001b[m";

    public MavenCli() {
        this(null);
    }

    public MavenCli(ClassWorld classWorld) {
        this.classWorld = classWorld;
        this.messageBuilderFactory = new JLineMessageBuilderFactory();
    }

    public static void main(String[] args) {
        int result = MavenCli.main(args, null);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        MessageUtils.systemInstall();
        MessageUtils.registerShutdownHook();
        int result = cli.doMain(new CliRequest(args, classWorld));
        MessageUtils.systemUninstall();
        return result;
    }

    public static int doMain(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(new CliRequest(args, classWorld));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(String[] args, String workingDirectory, PrintStream stdout, PrintStream stderr) {
        Set realms;
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        if (this.classWorld != null) {
            realms = new HashSet();
            for (ClassRealm realm : this.classWorld.getRealms()) {
                realms.add(realm.getId());
            }
        } else {
            realms = Collections.emptySet();
        }
        try {
            if (stdout != null) {
                System.setOut(stdout);
            }
            if (stderr != null) {
                System.setErr(stderr);
            }
            CliRequest cliRequest = new CliRequest(args, this.classWorld);
            cliRequest.workingDirectory = workingDirectory;
            int n = this.doMain(cliRequest);
            return n;
        }
        finally {
            if (this.classWorld != null) {
                for (ClassRealm realm : new ArrayList(this.classWorld.getRealms())) {
                    String realmId = realm.getId();
                    if (realms.contains(realmId)) continue;
                    try {
                        this.classWorld.disposeRealm(realmId);
                    }
                    catch (NoSuchRealmException noSuchRealmException) {}
                }
            }
            System.setOut(oldout);
            System.setErr(olderr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(CliRequest cliRequest) {
        PlexusContainer localContainer = null;
        try {
            this.initialize(cliRequest);
            this.cli(cliRequest);
            this.properties(cliRequest);
            this.logging(cliRequest);
            this.informativeCommands(cliRequest);
            this.version(cliRequest);
            localContainer = this.container(cliRequest);
            this.commands(cliRequest);
            this.configure(cliRequest);
            this.toolchains(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            int n = e.exitCode;
            return n;
        }
        catch (UnrecognizedOptionException e) {
            int n = 1;
            return n;
        }
        catch (BuildAbort e) {
            CLIReportingUtils.showError(this.slf4jLogger, "ABORTED", e, cliRequest.showErrors);
            int n = 2;
            return n;
        }
        catch (Exception e) {
            CLIReportingUtils.showError(this.slf4jLogger, "Error executing Maven.", e, cliRequest.showErrors);
            int n = 1;
            return n;
        }
        finally {
            if (localContainer != null) {
                localContainer.dispose();
            }
        }
    }

    void initialize(CliRequest cliRequest) throws ExitException {
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if (cliRequest.multiModuleProjectDirectory == null) {
            String basedirProperty = System.getProperty(MULTIMODULE_PROJECT_DIRECTORY);
            if (basedirProperty == null) {
                System.err.format("-D%s system property is not set.", MULTIMODULE_PROJECT_DIRECTORY);
                throw new ExitException(1);
            }
            File basedir = new File(basedirProperty);
            try {
                cliRequest.multiModuleProjectDirectory = basedir.getCanonicalFile();
            }
            catch (IOException e) {
                cliRequest.multiModuleProjectDirectory = basedir.getAbsoluteFile();
            }
        }
        Path topDirectory = Paths.get(cliRequest.workingDirectory, new String[0]);
        boolean isAltFile = false;
        for (String arg : cliRequest.args) {
            if (isAltFile) {
                Path path = topDirectory.resolve(MavenCli.stripLeadingAndTrailingQuotes(arg));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    topDirectory = path;
                    break;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    topDirectory = path.getParent();
                    if (Files.isDirectory(topDirectory, new LinkOption[0])) break;
                    System.err.println("Directory " + String.valueOf(topDirectory) + " extracted from the -f/--file command-line argument " + arg + " does not exist");
                    throw new ExitException(1);
                }
                System.err.println("POM file " + arg + " specified with the -f/--file command line argument does not exist");
                throw new ExitException(1);
            }
            isAltFile = arg.equals("-f") || arg.equals("--file");
        }
        cliRequest.topDirectory = topDirectory = MavenCli.getCanonicalPath(topDirectory);
        RootLocator rootLocator = ServiceLoader.load(RootLocator.class).iterator().next();
        cliRequest.rootDirectory = rootLocator.findRoot(topDirectory);
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
    }

    void cli(CliRequest cliRequest) throws Exception {
        CommandLine mavenConfig;
        block14: {
            this.slf4jLogger = new Slf4jStdoutLogger();
            this.cliManager = new CLIManager();
            mavenConfig = null;
            try {
                File configFile = new File(cliRequest.multiModuleProjectDirectory, MVN_MAVEN_CONFIG);
                if (!configFile.isFile()) break block14;
                try (Stream<String> lines = Files.lines(configFile.toPath(), Charset.defaultCharset());){
                    String[] args = (String[])lines.filter(arg -> !arg.isEmpty() && !arg.startsWith("#")).toArray(String[]::new);
                    mavenConfig = this.cliManager.parse(args);
                    List unrecognized = mavenConfig.getArgList();
                    if (!unrecognized.isEmpty()) {
                        throw new ParseException("Unrecognized maven.config file entries: " + String.valueOf(unrecognized));
                    }
                }
            }
            catch (ParseException e) {
                System.err.println("Unable to parse maven.config file options: " + e.getMessage());
                this.cliManager.displayHelp(System.out);
                throw e;
            }
        }
        try {
            CommandLine mavenCli = this.cliManager.parse(cliRequest.args);
            cliRequest.commandLine = mavenConfig == null ? mavenCli : this.cliMerge(mavenConfig, mavenCli);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            this.cliManager.displayHelp(System.out);
            throw e;
        }
        try {
            if (cliRequest.commandLine.hasOption("llr")) {
                throw new UnrecognizedOptionException("Option '-llr' is not supported starting with Maven 3.9.1");
            }
        }
        catch (ParseException e) {
            System.err.println("Unsupported options: " + e.getMessage());
            this.cliManager.displayHelp(System.out);
            throw e;
        }
    }

    private void informativeCommands(CliRequest cliRequest) throws ExitException {
        if (cliRequest.commandLine.hasOption('h')) {
            this.cliManager.displayHelp(System.out);
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            if (cliRequest.commandLine.hasOption('q')) {
                System.out.println(CLIReportingUtils.showVersionMinimal());
            } else {
                System.out.println(CLIReportingUtils.showVersion());
            }
            throw new ExitException(0);
        }
        if (cliRequest.rootDirectory == null) {
            this.slf4jLogger.info("Unable to find the root directory. Create a .mvn directory in the root directory or add the root=\"true\" attribute on the root project's model to identify it.");
        }
    }

    private CommandLine cliMerge(CommandLine mavenConfig, CommandLine mavenCli) {
        CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
        for (String arg : mavenCli.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        ArrayList<Option> setPropertyOptions = new ArrayList<Option>();
        for (Option opt : mavenCli.getOptions()) {
            if (String.valueOf('D').equals(opt.getOpt())) {
                setPropertyOptions.add(opt);
                continue;
            }
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : mavenConfig.getOptions()) {
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : setPropertyOptions) {
            commandLineBuilder.addOption(opt);
        }
        return commandLineBuilder.build();
    }

    void logging(CliRequest cliRequest) {
        CommandLine commandLine = cliRequest.commandLine;
        cliRequest.verbose = commandLine.hasOption('X') || commandLine.hasOption("debug");
        cliRequest.quiet = !cliRequest.verbose && commandLine.hasOption('q');
        cliRequest.showErrors = cliRequest.verbose || commandLine.hasOption('e');
        String styleColor = cliRequest.getUserProperties().getProperty(STYLE_COLOR_PROPERTY, "auto");
        if ("always".equals(styleColor = commandLine.getOptionValue("color", styleColor)) || "yes".equals(styleColor) || "force".equals(styleColor)) {
            MessageUtils.setColorEnabled((boolean)true);
        } else if ("never".equals(styleColor) || "no".equals(styleColor) || "none".equals(styleColor)) {
            MessageUtils.setColorEnabled((boolean)false);
        } else {
            boolean isBatchMode;
            if (!("auto".equals(styleColor) || "tty".equals(styleColor) || "if-tty".equals(styleColor))) {
                throw new IllegalArgumentException("Invalid color configuration value '" + styleColor + "'. Supported are 'auto', 'always', 'never'.");
            }
            boolean bl = isBatchMode = !commandLine.hasOption("force-interactive") && (commandLine.hasOption('B') || commandLine.hasOption("non-interactive"));
            if (isBatchMode || commandLine.hasOption("l")) {
                MessageUtils.setColorEnabled((boolean)false);
            }
        }
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration(this.slf4jLoggerFactory);
        if (cliRequest.verbose) {
            cliRequest.request.setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        if (commandLine.hasOption("l")) {
            File logFile = new File(commandLine.getOptionValue("l"));
            logFile = ResolveFile.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException ps) {
                // empty catch block
            }
        }
        slf4jConfiguration.activate();
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        if (commandLine.hasOption("fos")) {
            String logLevelThreshold = commandLine.getOptionValue("fos");
            if (this.slf4jLoggerFactory instanceof MavenSlf4jWrapperFactory) {
                LogLevelRecorder logLevelRecorder = new LogLevelRecorder(logLevelThreshold);
                ((MavenSlf4jWrapperFactory)this.slf4jLoggerFactory).setLogLevelRecorder(logLevelRecorder);
                this.slf4jLogger.info("Enabled to break the build on log level {}.", (Object)logLevelThreshold);
            } else {
                this.slf4jLogger.warn("Expected LoggerFactory to be of type '{}', but found '{}' instead. The --fail-on-severity flag will not take effect.", (Object)MavenSlf4jWrapperFactory.class.getName(), (Object)this.slf4jLoggerFactory.getClass().getName());
            }
        }
        if (commandLine.hasOption("debug")) {
            this.slf4jLogger.warn("The option '--debug' is deprecated and may be repurposed as Java debug in a future version. Use -X/--verbose instead.");
        }
    }

    private void version(CliRequest cliRequest) {
        if (cliRequest.verbose || cliRequest.commandLine.hasOption('V')) {
            System.out.println(CLIReportingUtils.showVersion());
        }
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.showErrors) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            this.slf4jLogger.debug("Message scheme: {}", (Object)(MessageUtils.isColorEnabled() ? "color" : "plain"));
            if (MessageUtils.isColorEnabled()) {
                MessageBuilder buff = MessageUtils.builder();
                buff.a((CharSequence)"Message styles: ");
                buff.trace((Object)"trace").a((Object)Character.valueOf(' '));
                buff.debug((Object)"debug").a((Object)Character.valueOf(' '));
                buff.info((Object)"info").a((Object)Character.valueOf(' '));
                buff.warning((Object)"warning").a((Object)Character.valueOf(' '));
                buff.error((Object)"error").a((Object)Character.valueOf(' '));
                buff.success((Object)"success").a((Object)Character.valueOf(' '));
                buff.failure((Object)"failure").a((Object)Character.valueOf(' '));
                buff.strong((Object)"strong").a((Object)Character.valueOf(' '));
                buff.mojo((Object)"mojo").a((Object)Character.valueOf(' '));
                buff.project((Object)"project");
                this.slf4jLogger.debug(buff.toString());
            }
        }
    }

    void properties(CliRequest cliRequest) throws Exception {
        Properties paths = new Properties();
        if (cliRequest.topDirectory != null) {
            paths.put("session.topDirectory", cliRequest.topDirectory.toString());
        }
        if (cliRequest.rootDirectory != null) {
            paths.put("session.rootDirectory", cliRequest.rootDirectory.toString());
        }
        MavenCli.populateProperties(cliRequest.commandLine, paths, cliRequest.systemProperties, cliRequest.userProperties);
        BasicInterpolator interpolator = MavenCli.createInterpolator(paths, cliRequest.systemProperties, cliRequest.userProperties);
        CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
        for (Option option : cliRequest.commandLine.getOptions()) {
            if (!String.valueOf('D').equals(option.getOpt())) {
                List values = option.getValuesList();
                ListIterator<String> it = values.listIterator();
                while (it.hasNext()) {
                    it.set(interpolator.interpolate((String)it.next()));
                }
            }
            commandLineBuilder.addOption(option);
        }
        for (String arg : cliRequest.commandLine.getArgList()) {
            commandLineBuilder.addArg(interpolator.interpolate(arg));
        }
        cliRequest.commandLine = commandLineBuilder.build();
    }

    PlexusContainer container(final CliRequest cliRequest) throws Exception {
        ClassRealm coreRealm;
        if (cliRequest.classWorld == null) {
            cliRequest.classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        }
        if ((coreRealm = cliRequest.classWorld.getClassRealm("plexus.core")) == null) {
            coreRealm = (ClassRealm)cliRequest.classWorld.getRealms().iterator().next();
        }
        List<File> extClassPath = this.parseExtClasspath(cliRequest);
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom((ClassRealm)coreRealm);
        List<CoreExtensionEntry> extensions = this.loadCoreExtensions(cliRequest, coreRealm, coreEntry.getExportedArtifacts());
        ClassRealm containerRealm = this.setupContainerRealm(cliRequest.classWorld, coreRealm, extClassPath, extensions);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        HashSet exportedArtifacts = new HashSet(coreEntry.getExportedArtifacts());
        HashSet exportedPackages = new HashSet(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensions) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)MavenCli.this.slf4jLoggerFactory);
                this.bind(CoreExports.class).toInstance((Object)exports);
                this.bind(MessageBuilderFactory.class).toInstance((Object)MavenCli.this.messageBuilderFactory);
            }
        }});
        container.setLookupRealm(null);
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        container.setLoggerManager(this.plexusLoggerManager);
        AbstractValueSource extensionSource = new AbstractValueSource(false){

            public Object getValue(String expression) {
                String value = cliRequest.userProperties.getProperty(expression);
                if (value == null) {
                    value = cliRequest.systemProperties.getProperty(expression);
                }
                return value;
            }
        };
        for (CoreExtensionEntry extension : extensions) {
            container.discoverComponents(extension.getClassRealm(), new Module[]{new SessionScopeModule((SessionScope)container.lookup(SessionScope.class)), new MojoExecutionScopeModule((MojoExecutionScope)container.lookup(MojoExecutionScope.class)), new ExtensionConfigurationModule(extension, new ValueSource[]{extensionSource})});
        }
        this.customizeContainer((PlexusContainer)container);
        container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
        this.eventSpyDispatcher = (EventSpyDispatcher)container.lookup(EventSpyDispatcher.class);
        DefaultEventSpyContext eventSpyContext = new DefaultEventSpyContext();
        Map<String, Object> data = eventSpyContext.getData();
        data.put("plexus", container);
        data.put("workingDirectory", cliRequest.workingDirectory);
        data.put("systemProperties", cliRequest.systemProperties);
        data.put("userProperties", cliRequest.userProperties);
        data.put("versionProperties", CLIReportingUtils.getBuildProperties());
        this.eventSpyDispatcher.init((EventSpy.Context)eventSpyContext);
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        this.maven = (Maven)container.lookup(Maven.class);
        this.executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        this.modelProcessor = this.createModelProcessor((PlexusContainer)container);
        this.configurationProcessors = container.lookupMap(ConfigurationProcessor.class);
        this.toolchainsBuilder = (ToolchainsBuilder)container.lookup(ToolchainsBuilder.class);
        this.dispatcher = (DefaultSecDispatcher)container.lookup(SecDispatcher.class, "maven");
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreExtensionEntry> loadCoreExtensions(CliRequest cliRequest, ClassRealm containerRealm, Set<String> providedArtifacts) throws Exception {
        if (cliRequest.multiModuleProjectDirectory == null) {
            return Collections.emptyList();
        }
        File extensionsFile = new File(cliRequest.multiModuleProjectDirectory, MVN_EXTENSIONS_FILENAME);
        File userHomeExtensionsFile = new File(USER_MAVEN_CONFIGURATION_HOME, EXTENSIONS_FILENAME);
        ArrayList<CoreExtension> extensions = new ArrayList<CoreExtension>();
        if (extensionsFile.isFile()) {
            extensions.addAll(this.readCoreExtensionsDescriptor(extensionsFile));
        }
        if (userHomeExtensionsFile.isFile()) {
            extensions.addAll(this.readCoreExtensionsDescriptor(userHomeExtensionsFile));
        }
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)MavenCli.this.slf4jLoggerFactory);
            }
        }});
        try {
            container.setLookupRealm(null);
            container.setLoggerManager(this.plexusLoggerManager);
            container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
            Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
            this.executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
            this.configurationProcessors = container.lookupMap(ConfigurationProcessor.class);
            this.configure(cliRequest);
            MavenExecutionRequest request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)cliRequest.request);
            this.populateRequest(cliRequest, request);
            request = this.executionRequestPopulator.populateDefaults(request);
            BootstrapCoreExtensionManager resolver = (BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class);
            List<CoreExtensionEntry> list = Collections.unmodifiableList(resolver.loadCoreExtensions(request, providedArtifacts, extensions));
            return list;
        }
        finally {
            this.executionRequestPopulator = null;
            container.dispose();
        }
    }

    private List<CoreExtension> readCoreExtensionsDescriptor(File extensionsFile) throws IOException, XMLStreamException {
        CoreExtensionsStaxReader parser = new CoreExtensionsStaxReader();
        try (InputStream is = Files.newInputStream(extensionsFile.toPath(), new OpenOption[0]);){
            List<CoreExtension> list = parser.read(is, true).getExtensions();
            return list;
        }
    }

    private ClassRealm setupContainerRealm(ClassWorld classWorld, ClassRealm coreRealm, List<File> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (!extClassPath.isEmpty() || !extensions.isEmpty()) {
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            extRealm.setParentRealm(coreRealm);
            this.slf4jLogger.debug("Populating class realm '{}'", (Object)extRealm.getId());
            for (File file : extClassPath) {
                this.slf4jLogger.debug("  included '{}'", (Object)file);
                extRealm.addURL(file.toURI().toURL());
            }
            for (CoreExtensionEntry entry : MavenCli.reverse(extensions)) {
                Set exportedPackages = entry.getExportedPackages();
                ClassRealm realm = entry.getClassRealm();
                for (String exportedPackage : exportedPackages) {
                    extRealm.importFrom((ClassLoader)realm, exportedPackage);
                }
                if (!exportedPackages.isEmpty()) continue;
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            return extRealm;
        }
        return coreRealm;
    }

    private static <T> List<T> reverse(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        Collections.reverse(copy);
        return copy;
    }

    private List<File> parseExtClasspath(CliRequest cliRequest) {
        String extClassPath = cliRequest.userProperties.getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.systemProperties.getProperty(EXT_CLASS_PATH);
        }
        ArrayList<File> jars = new ArrayList<File>();
        if (extClassPath != null && !extClassPath.isEmpty()) {
            for (String jar : extClassPath.split(File.pathSeparator)) {
                File file = ResolveFile.resolveFile(new File(jar), cliRequest.workingDirectory);
                this.slf4jLogger.debug("  included '{}'", (Object)file);
                jars.add(file);
            }
        }
        return jars;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            String passwd = cliRequest.commandLine.getOptionValue("emp");
            if (passwd == null) {
                char[] password;
                Console cons = System.console();
                char[] cArray = password = cons == null ? null : cons.readPassword("Master password: ", new Object[0]);
                if (password != null) {
                    passwd = String.copyValueOf(password);
                    Arrays.fill(password, ' ');
                }
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            System.out.println(cipher.encryptAndDecorate(passwd, "settings.security"));
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            Object configurationFile;
            String passwd = cliRequest.commandLine.getOptionValue("ep");
            if (passwd == null) {
                char[] password;
                Console cons = System.console();
                char[] cArray = password = cons == null ? null : cons.readPassword("Password: ", new Object[0]);
                if (password != null) {
                    passwd = String.copyValueOf(password);
                    Arrays.fill(password, ' ');
                }
            }
            if (((String)(configurationFile = this.dispatcher.getConfigurationFile())).startsWith("~")) {
                configurationFile = System.getProperty("user.home") + ((String)configurationFile).substring(1);
            }
            String file = System.getProperty("settings.security", (String)configurationFile);
            String master = null;
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            System.out.println(cipher.encryptAndDecorate(passwd, masterPasswd));
            throw new ExitException(0);
        }
    }

    private int execute(CliRequest cliRequest) throws MavenExecutionRequestPopulationException {
        MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.request);
        if (cliRequest.request.getRepositoryCache() == null) {
            cliRequest.request.setRepositoryCache((RepositoryCache)new DefaultRepositoryCache());
        }
        this.eventSpyDispatcher.onEvent((Object)request);
        MavenExecutionResult result = this.maven.execute(request);
        this.eventSpyDispatcher.onEvent((Object)result);
        this.eventSpyDispatcher.close();
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            ArrayList<MavenProject> failedProjects = new ArrayList<MavenProject>();
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", cliRequest.showErrors);
                if (!(throwable instanceof LifecycleExecutionException)) continue;
                failedProjects.add(((LifecycleExecutionException)throwable).getProject());
            }
            this.slf4jLogger.error("");
            if (!cliRequest.showErrors) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the '{}' switch", (Object)MessageUtils.builder().strong((Object)"-e"));
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the '{}' switch to enable verbose output", (Object)MessageUtils.builder().strong((Object)"-X"));
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error("{} {}", (Object)MessageUtils.builder().strong(entry.getValue()), entry.getKey());
                }
            }
            if (result.canResume()) {
                this.logBuildResumeHint("mvn [args] -r");
            } else if (!failedProjects.isEmpty()) {
                List sortedProjects = result.getTopologicallySortedProjects();
                failedProjects.sort(Comparator.comparing(sortedProjects::indexOf));
                MavenProject mavenProject = (MavenProject)failedProjects.get(0);
                if (!mavenProject.equals(sortedProjects.get(0))) {
                    String resumeFromSelector = this.getResumeFromSelector(sortedProjects, mavenProject);
                    this.logBuildResumeHint("mvn [args] -rf " + resumeFromSelector);
                }
            }
            if ("FAIL_NEVER".equals(cliRequest.request.getReactorFailureBehavior())) {
                this.slf4jLogger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private void logBuildResumeHint(String resumeBuildHint) {
        this.slf4jLogger.error("");
        this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
        this.slf4jLogger.error(MessageUtils.builder().a((CharSequence)"  ").strong((Object)resumeBuildHint).toString());
    }

    String getResumeFromSelector(List<MavenProject> mavenProjects, MavenProject firstFailedProject) {
        boolean hasOverlappingArtifactId;
        boolean bl = hasOverlappingArtifactId = mavenProjects.stream().filter(project -> firstFailedProject.getArtifactId().equals(project.getArtifactId())).count() > 1L;
        if (hasOverlappingArtifactId) {
            return firstFailedProject.getGroupId() + ":" + firstFailedProject.getArtifactId();
        }
        return ":" + firstFailedProject.getArtifactId();
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String referenceKey = "";
        if (summary.getReference() != null && !summary.getReference().isEmpty()) {
            referenceKey = references.computeIfAbsent(summary.getReference(), k -> "[Help " + (references.size() + 1) + "]");
        }
        Object msg = summary.getMessage();
        if (referenceKey != null && !referenceKey.isEmpty()) {
            msg = ((String)msg).indexOf(10) < 0 ? (String)msg + " -> " + String.valueOf(MessageUtils.builder().strong((Object)referenceKey)) : (String)msg + "\n-> " + String.valueOf(MessageUtils.builder().strong((Object)referenceKey));
        }
        String[] lines = NEXT_LINE.split((CharSequence)msg);
        String currentColor = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = currentColor + lines[i];
            Matcher matcher = LAST_ANSI_SEQUENCE.matcher(line);
            String nextColor = "";
            if (matcher.find() && ANSI_RESET.equals(nextColor = matcher.group(1))) {
                nextColor = "";
            }
            line = (String)indent + line + ("".equals(nextColor) ? "" : ANSI_RESET);
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
            } else {
                this.slf4jLogger.error(line);
            }
            currentColor = nextColor;
        }
        indent = (String)indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, (String)indent, showErrors);
        }
    }

    private void configure(CliRequest cliRequest) throws Exception {
        cliRequest.request.setEventSpyDispatcher(this.eventSpyDispatcher);
        int userSuppliedConfigurationProcessorCount = this.configurationProcessors.size() - 1;
        if (userSuppliedConfigurationProcessorCount == 0) {
            this.configurationProcessors.get("settings").process(cliRequest);
        } else if (userSuppliedConfigurationProcessorCount == 1) {
            for (Map.Entry<String, ConfigurationProcessor> entry : this.configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                configurationProcessor.process(cliRequest);
            }
        } else if (userSuppliedConfigurationProcessorCount > 1) {
            StringBuilder sb = new StringBuilder(String.format("%nThere can only be one user supplied ConfigurationProcessor, there are %s:%n%n", userSuppliedConfigurationProcessorCount));
            for (Map.Entry<String, ConfigurationProcessor> entry : this.configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                sb.append(String.format("%s%n", configurationProcessor.getClass().getName()));
            }
            throw new Exception(sb.toString());
        }
    }

    void toolchains(CliRequest cliRequest) throws Exception {
        File globalToolchainsFile;
        File userToolchainsFile;
        if (cliRequest.commandLine.hasOption('t')) {
            userToolchainsFile = new File(cliRequest.commandLine.getOptionValue('t'));
            if (!(userToolchainsFile = ResolveFile.resolveFile(userToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + String.valueOf(userToolchainsFile));
            }
        } else {
            userToolchainsFile = DEFAULT_USER_TOOLCHAINS_FILE;
        }
        if (cliRequest.commandLine.hasOption("gt")) {
            globalToolchainsFile = new File(cliRequest.commandLine.getOptionValue("gt"));
            if (!(globalToolchainsFile = ResolveFile.resolveFile(globalToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global toolchains file does not exist: " + String.valueOf(globalToolchainsFile));
            }
        } else {
            globalToolchainsFile = DEFAULT_GLOBAL_TOOLCHAINS_FILE;
        }
        cliRequest.request.setGlobalToolchainsFile(globalToolchainsFile);
        cliRequest.request.setUserToolchainsFile(userToolchainsFile);
        DefaultToolchainsBuildingRequest toolchainsRequest = new DefaultToolchainsBuildingRequest();
        if (globalToolchainsFile.isFile()) {
            toolchainsRequest.setGlobalToolchainsSource((Source)new FileSource(globalToolchainsFile));
        }
        if (userToolchainsFile.isFile()) {
            toolchainsRequest.setUserToolchainsSource((Source)new FileSource(userToolchainsFile));
        }
        this.eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        this.slf4jLogger.debug("Reading global toolchains from '{}'", this.getLocation(toolchainsRequest.getGlobalToolchainsSource(), globalToolchainsFile));
        this.slf4jLogger.debug("Reading user toolchains from '{}'", this.getLocation(toolchainsRequest.getUserToolchainsSource(), userToolchainsFile));
        ToolchainsBuildingResult toolchainsResult = this.toolchainsBuilder.build((ToolchainsBuildingRequest)toolchainsRequest);
        this.eventSpyDispatcher.onEvent((Object)toolchainsResult);
        this.executionRequestPopulator.populateFromToolchains(cliRequest.request, toolchainsResult.getEffectiveToolchains());
        if (!toolchainsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective toolchains");
            for (Problem problem : toolchainsResult.getProblems()) {
                this.slf4jLogger.warn("{} @ {}", (Object)problem.getMessage(), (Object)problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    protected MavenExecutionRequest populateRequest(CliRequest cliRequest) {
        return this.populateRequest(cliRequest, cliRequest.request);
    }

    private MavenExecutionRequest populateRequest(CliRequest cliRequest, MavenExecutionRequest request) {
        int degreeOfConcurrency;
        String threadConfiguration;
        boolean strictArtifactDescriptorPolicy;
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean quiet = cliRequest.quiet;
        boolean verbose = cliRequest.verbose;
        request.setShowErrors(cliRequest.showErrors);
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        this.disableInteractiveModeIfNeeded(cliRequest, request);
        this.enableOnPresentOption(commandLine, "nsu", arg_0 -> ((MavenExecutionRequest)request).setNoSnapshotUpdates(arg_0));
        request.setGoals(commandLine.getArgList());
        request.setReactorFailureBehavior(this.determineReactorFailureBehaviour(commandLine));
        this.disableOnPresentOption(commandLine, 'N', arg_0 -> ((MavenExecutionRequest)request).setRecursive(arg_0));
        this.enableOnPresentOption(commandLine, 'o', arg_0 -> ((MavenExecutionRequest)request).setOffline(arg_0));
        this.enableOnPresentOption(commandLine, 'U', arg_0 -> ((MavenExecutionRequest)request).setUpdateSnapshots(arg_0));
        request.setGlobalChecksumPolicy(this.determineGlobalCheckPolicy(commandLine));
        request.setBaseDirectory(baseDirectory);
        request.setSystemProperties(cliRequest.systemProperties);
        request.setUserProperties(cliRequest.userProperties);
        request.setMultiModuleProjectDirectory(cliRequest.multiModuleProjectDirectory);
        request.setRootDirectory(cliRequest.rootDirectory);
        request.setTopDirectory(cliRequest.topDirectory);
        request.setPom(this.determinePom(commandLine, workingDirectory, baseDirectory));
        request.setTransferListener(this.determineTransferListener(quiet, verbose, commandLine, request));
        request.setExecutionListener(this.determineExecutionListener());
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        request.setResumeFrom(commandLine.getOptionValue("rf"));
        this.enableOnPresentOption(commandLine, "r", arg_0 -> ((MavenExecutionRequest)request).setResume(arg_0));
        request.setMakeBehavior(this.determineMakeBehavior(commandLine));
        boolean cacheNotFound = !commandLine.hasOption("canf") || Boolean.parseBoolean(commandLine.getOptionValue("canf"));
        request.setCacheNotFound(cacheNotFound);
        request.setCacheTransferError(false);
        boolean bl = strictArtifactDescriptorPolicy = commandLine.hasOption("sadp") && Boolean.parseBoolean(commandLine.getOptionValue("sadp"));
        if (strictArtifactDescriptorPolicy) {
            request.setIgnoreMissingArtifactDescriptor(false);
            request.setIgnoreInvalidArtifactDescriptor(false);
        } else {
            request.setIgnoreMissingArtifactDescriptor(true);
            request.setIgnoreInvalidArtifactDescriptor(true);
        }
        this.enableOnPresentOption(commandLine, "itr", arg_0 -> ((MavenExecutionRequest)request).setIgnoreTransitiveRepositories(arg_0));
        MavenCli.performProjectActivation(commandLine, request.getProjectActivation());
        MavenCli.performProfileActivation(commandLine, request.getProfileActivation());
        String localRepositoryPath = this.determineLocalRepositoryPath(request);
        if (localRepositoryPath != null) {
            request.setLocalRepositoryPath(localRepositoryPath);
        }
        if ((threadConfiguration = commandLine.getOptionValue("T")) != null && (degreeOfConcurrency = this.calculateDegreeOfConcurrency(threadConfiguration)) > 1) {
            request.setBuilderId("multithreaded");
            request.setDegreeOfConcurrency(degreeOfConcurrency);
        }
        request.setBuilderId(commandLine.getOptionValue("b", request.getBuilderId()));
        return request;
    }

    private void disableInteractiveModeIfNeeded(CliRequest cliRequest, MavenExecutionRequest request) {
        CommandLine commandLine = cliRequest.getCommandLine();
        if (commandLine.hasOption("force-interactive")) {
            return;
        }
        if (commandLine.hasOption('B') || commandLine.hasOption("non-interactive")) {
            request.setInteractiveMode(false);
        } else {
            boolean runningOnCI = MavenCli.isRunningOnCI(cliRequest.getSystemProperties());
            if (runningOnCI) {
                this.slf4jLogger.info("Making this build non-interactive, because the environment variable CI equals \"true\". Disable this detection by removing that variable or adding --force-interactive.");
                request.setInteractiveMode(false);
            }
        }
    }

    private static boolean isRunningOnCI(Properties systemProperties) {
        String ciEnv = systemProperties.getProperty("env.CI");
        return ciEnv != null && !"false".equals(ciEnv);
    }

    private String determineLocalRepositoryPath(MavenExecutionRequest request) {
        String userDefinedLocalRepo = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (userDefinedLocalRepo != null) {
            return userDefinedLocalRepo;
        }
        return request.getSystemProperties().getProperty(LOCAL_REPO_PROPERTY);
    }

    private File determinePom(CommandLine commandLine, String workingDirectory, File baseDirectory) {
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        File current = baseDirectory;
        if (alternatePomFile != null) {
            current = ResolveFile.resolveFile(new File(alternatePomFile), workingDirectory);
        }
        if (this.modelProcessor != null) {
            return this.modelProcessor.locateExistingPom(current);
        }
        return current.isFile() ? current : null;
    }

    static void performProjectActivation(CommandLine commandLine, ProjectActivation projectActivation) {
        if (commandLine.hasOption("pl")) {
            String[] optionValues = commandLine.getOptionValues("pl");
            if (optionValues == null || optionValues.length == 0) {
                return;
            }
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String selector = token.trim();
                    boolean active = true;
                    if (selector.charAt(0) == '-' || selector.charAt(0) == '!') {
                        active = false;
                        selector = selector.substring(1);
                    } else if (token.charAt(0) == '+') {
                        selector = selector.substring(1);
                    }
                    boolean optional = selector.charAt(0) == '?';
                    selector = selector.substring(optional ? 1 : 0);
                    projectActivation.addProjectActivation(selector, active, optional);
                }
            }
        }
    }

    static void performProfileActivation(CommandLine commandLine, ProfileActivation profileActivation) {
        if (commandLine.hasOption('P')) {
            String[] optionValues = commandLine.getOptionValues('P');
            if (optionValues == null || optionValues.length == 0) {
                return;
            }
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String profileId = token.trim();
                    boolean active = true;
                    if (profileId.charAt(0) == '-' || profileId.charAt(0) == '!') {
                        active = false;
                        profileId = profileId.substring(1);
                    } else if (token.charAt(0) == '+') {
                        profileId = profileId.substring(1);
                    }
                    boolean optional = profileId.charAt(0) == '?';
                    profileId = profileId.substring(optional ? 1 : 0);
                    profileActivation.addProfileActivation(profileId, active, optional);
                }
            }
        }
    }

    private ExecutionListener determineExecutionListener() {
        ExecutionEventLogger executionListener = new ExecutionEventLogger(this.messageBuilderFactory);
        if (this.eventSpyDispatcher != null) {
            return this.eventSpyDispatcher.chainListener((ExecutionListener)executionListener);
        }
        return executionListener;
    }

    private String determineReactorFailureBehaviour(CommandLine commandLine) {
        if (commandLine.hasOption("ff")) {
            return "FAIL_FAST";
        }
        if (commandLine.hasOption("fae")) {
            return "FAIL_AT_END";
        }
        if (commandLine.hasOption("fn")) {
            return "FAIL_NEVER";
        }
        return "FAIL_FAST";
    }

    private TransferListener determineTransferListener(boolean quiet, boolean verbose, CommandLine commandLine, MavenExecutionRequest request) {
        boolean quietCI;
        boolean runningOnCI = MavenCli.isRunningOnCI(request.getSystemProperties());
        boolean bl = quietCI = runningOnCI && !commandLine.hasOption("force-interactive");
        if (quiet || commandLine.hasOption("ntp") || quietCI) {
            return new QuietMavenTransferListener();
        }
        if (request.isInteractiveMode() && !commandLine.hasOption("l")) {
            return this.getConsoleTransferListener(verbose);
        }
        return this.getBatchTransferListener();
    }

    private String determineMakeBehavior(CommandLine cl) {
        if (cl.hasOption("am") && !cl.hasOption("amd")) {
            return "make-upstream";
        }
        if (!cl.hasOption("am") && cl.hasOption("amd")) {
            return "make-downstream";
        }
        if (cl.hasOption("am") && cl.hasOption("amd")) {
            return "make-both";
        }
        return null;
    }

    private String determineGlobalCheckPolicy(CommandLine commandLine) {
        if (commandLine.hasOption('C')) {
            return "fail";
        }
        if (commandLine.hasOption('c')) {
            return "warn";
        }
        return null;
    }

    private void disableOnPresentOption(CommandLine commandLine, String option, Consumer<Boolean> setting) {
        if (commandLine.hasOption(option)) {
            setting.accept(false);
        }
    }

    private void disableOnPresentOption(CommandLine commandLine, char option, Consumer<Boolean> setting) {
        this.disableOnPresentOption(commandLine, String.valueOf(option), setting);
    }

    private void enableOnPresentOption(CommandLine commandLine, String option, Consumer<Boolean> setting) {
        if (commandLine.hasOption(option)) {
            setting.accept(true);
        }
    }

    private void enableOnPresentOption(CommandLine commandLine, char option, Consumer<Boolean> setting) {
        this.enableOnPresentOption(commandLine, String.valueOf(option), setting);
    }

    private void enableOnAbsentOption(CommandLine commandLine, char option, Consumer<Boolean> setting) {
        if (!commandLine.hasOption(option)) {
            setting.accept(true);
        }
    }

    int calculateDegreeOfConcurrency(String threadConfiguration) {
        try {
            if (threadConfiguration.endsWith("C")) {
                String str = threadConfiguration.substring(0, threadConfiguration.length() - 1);
                float coreMultiplier = Float.parseFloat(str);
                if (coreMultiplier <= 0.0f) {
                    throw new IllegalArgumentException("Invalid threads core multiplier value: '" + threadConfiguration + "'. Value must be positive.");
                }
                int procs = Runtime.getRuntime().availableProcessors();
                int threads = (int)(coreMultiplier * (float)procs);
                return threads == 0 ? 1 : threads;
            }
            int threads = Integer.parseInt(threadConfiguration);
            if (threads <= 0) {
                throw new IllegalArgumentException("Invalid threads value: '" + threadConfiguration + "'. Value must be positive.");
            }
            return threads;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid threads value: '" + threadConfiguration + "'. Supported are int and float values ending with C.");
        }
    }

    static void populateProperties(CommandLine commandLine, Properties paths, Properties systemProperties, Properties userProperties) throws Exception {
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        Properties userSpecifiedProperties = commandLine.getOptionProperties(String.valueOf('D'));
        SystemProperties.addSystemProperties((Properties)systemProperties);
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString(buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
        BasicInterpolator interpolator = MavenCli.createInterpolator(paths, systemProperties, userProperties, userSpecifiedProperties);
        for (Map.Entry<Object, Object> e : userSpecifiedProperties.entrySet()) {
            String name = (String)e.getKey();
            String value = interpolator.interpolate((String)e.getValue());
            userProperties.setProperty(name, value);
            if (System.getProperty(name) != null) continue;
            System.setProperty(name, value);
        }
    }

    private static BasicInterpolator createInterpolator(final Properties ... properties) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                for (Properties props : properties) {
                    String val = props.getProperty(expression);
                    if (val == null) continue;
                    return val;
                }
                return null;
            }
        });
        return interpolator;
    }

    private static String stripLeadingAndTrailingQuotes(String str) {
        int length = str.length();
        if (length > 1 && str.startsWith("\"") && str.endsWith("\"") && str.substring(1, length - 1).indexOf(34) == -1) {
            str = str.substring(1, length - 1);
        }
        return str;
    }

    private static Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return MavenCli.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    protected TransferListener getConsoleTransferListener(boolean printResourceNames) {
        return new SimplexTransferListener((TransferListener)new ConsoleMavenTransferListener(this.messageBuilderFactory, System.out, printResourceNames));
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected void customizeContainer(PlexusContainer container) {
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        int exitCode;

        ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

