/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.internal.extension.io;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.CoreExtensions;
import org.codehaus.stax2.util.StreamWriterDelegate;

@Generated
public class CoreExtensionsStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/EXTENSIONS/1.2.0";
    private static final String SCHEMA_LOCATION = "http://maven.apache.org/xsd/core-extensions-1.2.0.xsd";
    private String namespace = "http://maven.apache.org/EXTENSIONS/1.2.0";
    private String schemaLocation = "http://maven.apache.org/xsd/core-extensions-1.2.0.xsd";
    private String fileComment = null;

    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, CoreExtensions coreExtensions) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(coreExtensions.getModelEncoding(), null);
        this.writeCoreExtensions("extensions", coreExtensions, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, CoreExtensions coreExtensions) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, coreExtensions.getModelEncoding()));
        serializer.writeStartDocument(coreExtensions.getModelEncoding(), null);
        this.writeCoreExtensions("extensions", coreExtensions, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    private void writeCoreExtensions(String tagName, CoreExtensions coreExtensions, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (coreExtensions != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, this.namespace);
            serializer.writeNamespace("", this.namespace);
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.namespace + " " + this.schemaLocation);
            this.writeList("extensions", true, coreExtensions.getExtensions(), serializer, t -> this.writeCoreExtension("extension", (CoreExtension)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeCoreExtension(String tagName, CoreExtension coreExtension, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (coreExtension != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, coreExtension.getGroupId(), serializer);
            this.writeTag("artifactId", null, coreExtension.getArtifactId(), serializer);
            this.writeTag("version", null, coreExtension.getVersion(), serializer);
            this.writeTag("classLoadingStrategy", "self-first", coreExtension.getClassLoadingStrategy(), serializer);
            this.writeDom(coreExtension.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(this.namespace, tagName);
            }
            boolean index = false;
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(this.namespace, tagName);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(this.namespace, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                if (((String)attr.getKey()).startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace", ((String)attr.getKey()).substring(4), (String)attr.getValue());
                    continue;
                }
                serializer.writeAttribute((String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

