/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ArtifactCoordinatesFactory;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.VersionRangeResolver;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.cli.internal.ExtensionResolutionException;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.internal.impl.DefaultArtifactCoordinatesFactory;
import org.apache.maven.internal.impl.DefaultArtifactManager;
import org.apache.maven.internal.impl.DefaultArtifactResolver;
import org.apache.maven.internal.impl.DefaultModelVersionParser;
import org.apache.maven.internal.impl.DefaultRepositoryFactory;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.DefaultVersionParser;
import org.apache.maven.internal.impl.DefaultVersionRangeResolver;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import org.apache.maven.resolver.MavenChainedWorkspaceReader;
import org.apache.maven.resolver.RepositorySystemSessionFactory;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.VersionScheme;
import org.eclipse.sisu.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BootstrapCoreExtensionManager {
    public static final String STRATEGY_PARENT_FIRST = "parent-first";
    public static final String STRATEGY_PLUGIN = "plugin";
    public static final String STRATEGY_SELF_FIRST = "self-first";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DefaultPluginDependenciesResolver pluginDependenciesResolver;
    private final RepositorySystemSessionFactory repositorySystemSessionFactory;
    private final CoreExports coreExports;
    private final ClassWorld classWorld;
    private final ClassRealm parentRealm;
    private final WorkspaceReader ideWorkspaceReader;
    private final RepositorySystem repoSystem;

    @Inject
    public BootstrapCoreExtensionManager(DefaultPluginDependenciesResolver pluginDependenciesResolver, RepositorySystemSessionFactory repositorySystemSessionFactory, CoreExports coreExports, PlexusContainer container, @Nullable @Named(value="ide") WorkspaceReader ideWorkspaceReader, RepositorySystem repoSystem) {
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.repositorySystemSessionFactory = repositorySystemSessionFactory;
        this.coreExports = coreExports;
        this.classWorld = ((DefaultPlexusContainer)container).getClassWorld();
        this.parentRealm = container.getContainerRealm();
        this.ideWorkspaceReader = ideWorkspaceReader;
        this.repoSystem = repoSystem;
    }

    public List<CoreExtensionEntry> loadCoreExtensions(MavenExecutionRequest request, Set<String> providedArtifacts, List<CoreExtension> extensions) throws Exception {
        try (RepositorySystemSession.CloseableSession repoSession = this.repositorySystemSessionFactory.newRepositorySessionBuilder(request).setWorkspaceReader((WorkspaceReader)new MavenChainedWorkspaceReader(new WorkspaceReader[]{request.getWorkspaceReader(), this.ideWorkspaceReader})).build();){
            MavenSession mSession = new MavenSession((RepositorySystemSession)repoSession, request, (MavenExecutionResult)new DefaultMavenExecutionResult());
            SimpleSession iSession = new SimpleSession(mSession, this.repoSystem, null);
            InternalSession.associate((RepositorySystemSession)repoSession, (Session)iSession);
            List repositories = RepositoryUtils.toRepos((List)request.getPluginArtifactRepositories());
            Interpolator interpolator = BootstrapCoreExtensionManager.createInterpolator(request);
            List<CoreExtensionEntry> list = this.resolveCoreExtensions((RepositorySystemSession)repoSession, repositories, providedArtifacts, extensions, interpolator);
            return list;
        }
    }

    private List<CoreExtensionEntry> resolveCoreExtensions(RepositorySystemSession repoSession, List<org.eclipse.aether.repository.RemoteRepository> repositories, Set<String> providedArtifacts, List<CoreExtension> configuration, Interpolator interpolator) throws Exception {
        ArrayList<CoreExtensionEntry> extensions = new ArrayList<CoreExtensionEntry>();
        ExclusionsDependencyFilter dependencyFilter = new ExclusionsDependencyFilter(providedArtifacts);
        for (CoreExtension extension : configuration) {
            List<Artifact> artifacts = this.resolveExtension(extension, repoSession, repositories, (DependencyFilter)dependencyFilter, interpolator);
            if (artifacts.isEmpty()) continue;
            extensions.add(this.createExtension(extension, artifacts));
        }
        return Collections.unmodifiableList(extensions);
    }

    private CoreExtensionEntry createExtension(CoreExtension extension, List<Artifact> artifacts) throws Exception {
        String realmId = "coreExtension>" + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion();
        ClassRealm realm = this.classWorld.newRealm(realmId, null);
        Set providedArtifacts = Collections.emptySet();
        String classLoadingStrategy = extension.getClassLoadingStrategy();
        if (STRATEGY_PARENT_FIRST.equals(classLoadingStrategy)) {
            realm.importFrom((ClassLoader)this.parentRealm, "");
        } else if (STRATEGY_PLUGIN.equals(classLoadingStrategy)) {
            this.coreExports.getExportedPackages().forEach((p, cl) -> realm.importFrom(cl, p));
            providedArtifacts = this.coreExports.getExportedArtifacts();
        } else if (STRATEGY_SELF_FIRST.equals(classLoadingStrategy)) {
            realm.setParentRealm(this.parentRealm);
        } else {
            throw new IllegalArgumentException("Unsupported class-loading strategy '" + classLoadingStrategy + "'. Supported values are: parent-first, plugin and self-first");
        }
        this.log.debug("Populating class realm {}", (Object)realm.getId());
        for (Artifact artifact : artifacts) {
            String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (providedArtifacts.contains(id)) {
                this.log.debug("  Excluded {}", (Object)id);
                continue;
            }
            File file = artifact.getFile();
            this.log.debug("  Included {} located at {}", (Object)id, (Object)file);
            realm.addURL(file.toURI().toURL());
        }
        return CoreExtensionEntry.discoverFrom((ClassRealm)realm, Collections.singleton(artifacts.get(0).getFile()), (String)(extension.getGroupId() + ":" + extension.getArtifactId()), (XmlNode)extension.getConfiguration());
    }

    private List<Artifact> resolveExtension(CoreExtension extension, RepositorySystemSession repoSession, List<org.eclipse.aether.repository.RemoteRepository> repositories, DependencyFilter dependencyFilter, Interpolator interpolator) throws ExtensionResolutionException {
        try {
            org.apache.maven.api.model.Plugin plugin = org.apache.maven.api.model.Plugin.newBuilder().groupId(interpolator.interpolate(extension.getGroupId())).artifactId(interpolator.interpolate(extension.getArtifactId())).version(interpolator.interpolate(extension.getVersion())).build();
            DependencyResult result = this.pluginDependenciesResolver.resolveCoreExtension(new Plugin(plugin), dependencyFilter, repositories, repoSession);
            return result.getArtifactResults().stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).collect(Collectors.toList());
        }
        catch (PluginResolutionException | InterpolationException e) {
            throw new ExtensionResolutionException(extension, e);
        }
    }

    private static Interpolator createInterpolator(MavenExecutionRequest request) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)request.getUserProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)request.getSystemProperties()));
        return interpolator;
    }

    static class SimpleSession
    extends DefaultSession {
        SimpleSession(MavenSession session, RepositorySystem repositorySystem, List<RemoteRepository> repositories) {
            super(session, repositorySystem, repositories, null, null, null);
        }

        protected Session newSession(MavenSession mavenSession, List<RemoteRepository> repositories) {
            return new SimpleSession(mavenSession, this.getRepositorySystem(), repositories);
        }

        public <T extends Service> T getService(Class<T> clazz) throws NoSuchElementException {
            if (clazz == ArtifactCoordinatesFactory.class) {
                return (T)new DefaultArtifactCoordinatesFactory();
            }
            if (clazz == VersionParser.class) {
                return (T)new DefaultVersionParser((ModelVersionParser)new DefaultModelVersionParser((VersionScheme)new GenericVersionScheme()));
            }
            if (clazz == VersionRangeResolver.class) {
                return (T)new DefaultVersionRangeResolver(this.repositorySystem);
            }
            if (clazz == ArtifactResolver.class) {
                return (T)new DefaultArtifactResolver();
            }
            if (clazz == ArtifactManager.class) {
                return (T)new DefaultArtifactManager((InternalMavenSession)this);
            }
            if (clazz == RepositoryFactory.class) {
                return (T)new DefaultRepositoryFactory((RemoteRepositoryManager)new DefaultRemoteRepositoryManager((UpdatePolicyAnalyzer)new DefaultUpdatePolicyAnalyzer(), (ChecksumPolicyProvider)new DefaultChecksumPolicyProvider()));
            }
            throw new NoSuchElementException("No service for " + clazz.getName());
        }
    }
}

