/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.props;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "$__";

    private InterpolationHelper() {
    }

    public static void performSubstitution(Map<String, String> properties, Function<String, String> callback) {
        InterpolationHelper.performSubstitution(properties, callback, true, true);
    }

    public static void performSubstitution(Map<String, String> properties, Function<String, String> callback, boolean substituteFromConfig, boolean defaultsToEmptyString) {
        HashMap<String, String> org = new HashMap<String, String>(properties);
        for (String name : properties.keySet()) {
            properties.compute(name, (k, value) -> InterpolationHelper.substVars(value, name, null, org, callback, substituteFromConfig, defaultsToEmptyString));
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) {
        return InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, null);
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, Function<String, String> callback) {
        return InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, callback, true, false);
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, Function<String, String> callback, boolean substituteFromConfig, boolean defaultsToEmptyString) {
        return InterpolationHelper.unescape(InterpolationHelper.doSubstVars(val, currentKey, cycleMap, configProps, callback, substituteFromConfig, defaultsToEmptyString));
    }

    private static String doSubstVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, Function<String, String> callback, boolean substituteFromConfig, boolean defaultsToEmptyString) {
        String variable;
        int startDelim;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        do {
            int idx;
            stopDelim = ((String)val).indexOf(DELIM_STOP, stopDelim + 1);
            while (stopDelim > 0 && ((String)val).charAt(stopDelim - 1) == '\\') {
                stopDelim = ((String)val).indexOf(DELIM_STOP, stopDelim + 1);
            }
            startDelim = ((String)val).indexOf(DELIM_START);
            while (stopDelim >= 0 && (idx = ((String)val).indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim >= 0 && stopDelim >= 0 && stopDelim < startDelim + DELIM_START.length());
        if (startDelim < 0 || stopDelim < 0) {
            cycleMap.remove(currentKey);
            return val;
        }
        String org = variable = ((String)val).substring(startDelim + DELIM_START.length(), stopDelim);
        int idx1 = variable.lastIndexOf(":-");
        int idx2 = variable.lastIndexOf(":+");
        int idx = idx1 >= 0 && idx2 >= 0 ? Math.min(idx1, idx2) : (idx1 >= 0 ? idx1 : idx2);
        String op = null;
        if (idx >= 0) {
            op = variable.substring(idx);
            variable = variable.substring(0, idx);
        }
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        Object substValue = null;
        if (substituteFromConfig && configProps != null) {
            substValue = configProps.get(variable);
        }
        if (substValue == null && !variable.isEmpty() && callback != null) {
            substValue = callback.apply(variable);
        }
        if (op != null) {
            if (op.startsWith(":-")) {
                if (substValue == null || ((String)substValue).isEmpty()) {
                    substValue = op.substring(":-".length());
                }
            } else if (op.startsWith(":+")) {
                if (substValue != null && !((String)substValue).isEmpty()) {
                    substValue = op.substring(":+".length());
                }
            } else {
                throw new IllegalArgumentException("Bad substitution: ${" + org + DELIM_STOP);
            }
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "$__{" + variable + DELIM_STOP;
        }
        cycleMap.remove(variable);
        val = ((String)val).substring(0, startDelim) + (String)substValue + ((String)val).substring(stopDelim + DELIM_STOP.length());
        val = InterpolationHelper.doSubstVars((String)val, currentKey, cycleMap, configProps, callback, substituteFromConfig, defaultsToEmptyString);
        cycleMap.remove(currentKey);
        return val;
    }

    public static String escape(String val) {
        return val.replace("$", MARKER);
    }

    private static String unescape(String val) {
        val = ((String)val).replaceAll("\\$__", "\\$");
        int escape = ((String)val).indexOf(92);
        while (escape >= 0 && escape < ((String)val).length() - 1) {
            char c = ((String)val).charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = ((String)val).substring(0, escape) + ((String)val).substring(escape + 1);
            }
            escape = ((String)val).indexOf(92, escape + 1);
        }
        return val;
    }
}

