/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.props;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.maven.cli.props.InterpolationHelper;
import org.apache.maven.cli.props.MavenProperties;

public class MavenPropertiesLoader {
    public static final String INCLUDES_PROPERTY = "${includes}";
    public static final String OVERRIDE_PREFIX = "maven.override.";

    public static void loadProperties(Properties properties, Path path, Function<String, String> callback, boolean escape) throws IOException {
        MavenProperties sp = new MavenProperties(false);
        if (Files.exists(path, new LinkOption[0])) {
            sp.load(path);
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sp.put(k.toString(), escape ? InterpolationHelper.escape(v.toString()) : v.toString())));
        MavenPropertiesLoader.loadIncludes(path, sp, callback);
        MavenPropertiesLoader.substitute(sp, callback);
        sp.forEach(properties::setProperty);
    }

    public static void substitute(MavenProperties props, Function<String, String> callback) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            if (value == null) {
                value = callback.apply(name);
            }
            if (name.startsWith(OVERRIDE_PREFIX)) {
                String overrideName = name.substring(OVERRIDE_PREFIX.length());
                props.put(overrideName, InterpolationHelper.substVars(value, name, null, props, callback));
                continue;
            }
            props.put(name, InterpolationHelper.substVars(value, name, null, props, callback));
        }
        props.keySet().removeIf(k -> k.startsWith(OVERRIDE_PREFIX));
    }

    private static MavenProperties loadPropertiesFile(Path path, boolean failIfNotFound, Function<String, String> callback) throws IOException {
        MavenProperties configProps = new MavenProperties(null, false);
        if (Files.exists(path, new LinkOption[0]) || failIfNotFound) {
            configProps.load(path);
            MavenPropertiesLoader.loadIncludes(path, configProps, callback);
            MavenPropertiesLoader.trimValues(configProps);
        }
        return configProps;
    }

    private static void loadIncludes(Path configProp, MavenProperties configProps, Function<String, String> callback) throws IOException {
        StringTokenizer st;
        String includes = (String)configProps.get(INCLUDES_PROPERTY);
        if (includes != null && (st = new StringTokenizer(includes = InterpolationHelper.substVars(includes, INCLUDES_PROPERTY, null, configProps, callback), "?\",", true)).countTokens() > 0) {
            String location;
            do {
                if ((location = MavenPropertiesLoader.nextLocation(st)) == null) continue;
                boolean mandatory = true;
                if (location.startsWith("?")) {
                    mandatory = false;
                    location = location.substring(1);
                }
                Path path = configProp.resolveSibling(location);
                MavenProperties props = MavenPropertiesLoader.loadPropertiesFile(path, mandatory, s -> {
                    String v = (String)callback.apply((String)s);
                    return v != null ? v : configProps.getProperty((String)s);
                });
                configProps.putAll(props);
            } while (location != null);
        }
        configProps.remove(INCLUDES_PROPERTY);
    }

    private static void trimValues(MavenProperties configProps) {
        configProps.replaceAll((k, v) -> v.trim());
    }

    private static String nextLocation(StringTokenizer st) {
        boolean optional = false;
        Object retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "?\",";
            StringBuilder tokBuf = new StringBuilder(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            block10: while (st.hasMoreTokens() && !exit) {
                String tok;
                switch (tok = st.nextToken(tokenList)) {
                    case "\"": {
                        boolean bl = inQuote = !inQuote;
                        if (inQuote) {
                            tokenList = "\"";
                            continue block10;
                        }
                        tokenList = "\" ";
                        continue block10;
                    }
                    case ",": {
                        if (!tokStarted) continue block10;
                        retVal = tokBuf.toString();
                        tokStarted = false;
                        tokBuf = new StringBuilder(10);
                        exit = true;
                        continue block10;
                    }
                    case "?": {
                        optional = true;
                        continue block10;
                    }
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return optional ? "?" + retVal : retVal;
    }
}

