/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import org.apache.maven.api.services.MessageBuilder;

public class FileSizeFormat {
    public String format(long size) {
        return this.format(size, null);
    }

    public String format(long size, ScaleUnit unit) {
        return this.format(size, unit, false);
    }

    public String format(long size, ScaleUnit unit, boolean omitSymbol) {
        StringBuilder sb = new StringBuilder();
        this.format(sb, size, unit, omitSymbol);
        return sb.toString();
    }

    public void format(StringBuilder builder, long size) {
        this.format(builder, size, null, false);
    }

    public void format(StringBuilder builder, long size, ScaleUnit unit) {
        this.format(builder, size, unit, false);
    }

    private void format(StringBuilder builder, long size, ScaleUnit unit, boolean omitSymbol) {
        if (size < 0L) {
            throw new IllegalArgumentException("file size cannot be negative: " + size);
        }
        if (unit == null) {
            unit = ScaleUnit.getScaleUnit(size);
        }
        double scaledSize = (double)size / (double)unit.bytes();
        if (unit == ScaleUnit.BYTE) {
            builder.append(size);
        } else if (scaledSize < 0.05 || scaledSize >= 10.0) {
            builder.append(Math.round(scaledSize));
        } else {
            builder.append((double)Math.round(scaledSize * 10.0) / 10.0);
        }
        if (!omitSymbol) {
            builder.append(" ").append(unit.symbol());
        }
    }

    public void format(MessageBuilder builder, long size) {
        this.format(builder, size, null, false);
    }

    public void format(MessageBuilder builder, long size, ScaleUnit unit) {
        this.format(builder, size, unit, false);
    }

    private void format(MessageBuilder builder, long size, ScaleUnit unit, boolean omitSymbol) {
        if (size < 0L) {
            throw new IllegalArgumentException("file size cannot be negative: " + size);
        }
        if (unit == null) {
            unit = ScaleUnit.getScaleUnit(size);
        }
        double scaledSize = (double)size / (double)unit.bytes();
        if (unit == ScaleUnit.BYTE) {
            builder.append((CharSequence)Long.toString(size));
        } else if (scaledSize < 0.05 || scaledSize >= 10.0) {
            builder.append((CharSequence)Long.toString(Math.round(scaledSize)));
        } else {
            builder.append((CharSequence)Double.toString((double)Math.round(scaledSize * 10.0) / 10.0));
        }
        if (!omitSymbol) {
            builder.append((CharSequence)" ").append((CharSequence)unit.symbol());
        }
    }

    public String formatProgress(long progressedSize, long size) {
        StringBuilder sb = new StringBuilder();
        this.formatProgress(sb, progressedSize, size);
        return sb.toString();
    }

    public void formatProgress(StringBuilder builder, long progressedSize, long size) {
        if (progressedSize < 0L) {
            throw new IllegalArgumentException("progressed file size cannot be negative: " + size);
        }
        if (size >= 0L && progressedSize > size) {
            throw new IllegalArgumentException("progressed file size cannot be greater than size: " + progressedSize + " > " + size);
        }
        if (size >= 0L && progressedSize != size) {
            ScaleUnit unit = ScaleUnit.getScaleUnit(size);
            this.format(builder, progressedSize, unit, true);
            builder.append("/");
            this.format(builder, size, unit, false);
        } else {
            ScaleUnit unit = ScaleUnit.getScaleUnit(progressedSize);
            this.format(builder, progressedSize, unit, false);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ScaleUnit {
        BYTE{

            @Override
            public long bytes() {
                return 1L;
            }

            @Override
            public String symbol() {
                return "B";
            }
        }
        ,
        KILOBYTE{

            @Override
            public long bytes() {
                return 1000L;
            }

            @Override
            public String symbol() {
                return "kB";
            }
        }
        ,
        MEGABYTE{

            @Override
            public long bytes() {
                return KILOBYTE.bytes() * KILOBYTE.bytes();
            }

            @Override
            public String symbol() {
                return "MB";
            }
        }
        ,
        GIGABYTE{

            @Override
            public long bytes() {
                return MEGABYTE.bytes() * KILOBYTE.bytes();
            }

            @Override
            public String symbol() {
                return "GB";
            }
        };


        public abstract long bytes();

        public abstract String symbol();

        public static ScaleUnit getScaleUnit(long size) {
            if (size < 0L) {
                throw new IllegalArgumentException("file size cannot be negative: " + size);
            }
            if (size >= GIGABYTE.bytes()) {
                return GIGABYTE;
            }
            if (size >= MEGABYTE.bytes()) {
                return MEGABYTE;
            }
            if (size >= KILOBYTE.bytes()) {
                return KILOBYTE;
            }
            return BYTE;
        }
    }
}

