/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.SettingsBuilder;
import org.apache.maven.api.services.SettingsBuilderException;
import org.apache.maven.api.services.SettingsBuilderRequest;
import org.apache.maven.api.services.SettingsBuilderResult;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.xml.SettingsXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.internal.impl.DefaultBuilderProblem;
import org.apache.maven.internal.impl.DefaultSettingsValidator;
import org.apache.maven.internal.impl.DefaultSettingsXmlFactory;
import org.apache.maven.internal.impl.SettingsUtilsV4;
import org.apache.maven.internal.impl.model.DefaultInterpolator;
import org.apache.maven.settings.v4.SettingsMerger;
import org.apache.maven.settings.v4.SettingsTransformer;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.DefaultSecDispatcher;

@Named
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private final DefaultSettingsValidator settingsValidator = new DefaultSettingsValidator();
    private final SettingsMerger settingsMerger = new SettingsMerger();
    private final SettingsXmlFactory settingsXmlFactory;
    private final Interpolator interpolator;
    private final Map<String, Dispatcher> dispatchers;

    public DefaultSettingsBuilder() {
        this(new DefaultSettingsXmlFactory(), new DefaultInterpolator(), Map.of());
    }

    @Inject
    public DefaultSettingsBuilder(SettingsXmlFactory settingsXmlFactory, Interpolator interpolator, Map<String, Dispatcher> dispatchers) {
        this.settingsXmlFactory = settingsXmlFactory;
        this.interpolator = interpolator;
        this.dispatchers = dispatchers;
    }

    public SettingsBuilderResult build(SettingsBuilderRequest request) throws SettingsBuilderException {
        Path file;
        String localRepository;
        ArrayList<BuilderProblem> problems = new ArrayList<BuilderProblem>();
        Source installationSource = request.getInstallationSettingsSource().orElse(null);
        Settings installation = this.readSettings(installationSource, false, request, problems);
        Source projectSource = request.getProjectSettingsSource().orElse(null);
        Settings project = this.readSettings(projectSource, true, request, problems);
        Source userSource = request.getUserSettingsSource().orElse(null);
        Settings user = this.readSettings(userSource, false, request, problems);
        Settings effective = this.settingsMerger.merge(user, this.settingsMerger.merge(project, installation, false, null), false, null);
        if (effective.getRepositories().isEmpty() && effective.getPluginRepositories().isEmpty()) {
            Repository central = Repository.newBuilder().id("central").name("Central Repository").url("https://repo.maven.apache.org/maven2").snapshots(RepositoryPolicy.newBuilder().enabled(false).build()).build();
            Repository centralWithNoUpdate = central.withReleases(RepositoryPolicy.newBuilder().updatePolicy("never").build());
            effective = Settings.newBuilder((Settings)effective).repositories(List.of(central)).pluginRepositories(List.of(centralWithNoUpdate)).build();
        }
        if ((localRepository = effective.getLocalRepository()) != null && !localRepository.isEmpty() && !(file = Paths.get(localRepository, new String[0])).isAbsolute() && file.toString().startsWith(File.separator)) {
            effective = effective.withLocalRepository(file.toAbsolutePath().toString());
        }
        if (this.hasErrors(problems)) {
            throw new SettingsBuilderException("Error building settings", problems);
        }
        return new DefaultSettingsBuilderResult(effective, problems);
    }

    private boolean hasErrors(List<BuilderProblem> problems) {
        if (problems != null) {
            for (BuilderProblem problem : problems) {
                if (BuilderProblem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private Settings readSettings(Source settingsSource, boolean isProjectSettings, SettingsBuilderRequest request, List<BuilderProblem> problems) {
        Settings settings;
        if (settingsSource == null) {
            return Settings.newInstance();
        }
        try {
            try (InputStream is = settingsSource.openStream();){
                settings = (Settings)this.settingsXmlFactory.read(XmlReaderRequest.builder().inputStream(is).location(settingsSource.getLocation()).strict(true).build());
            }
            catch (XmlReaderException e) {
                try (InputStream is2 = settingsSource.openStream();){
                    Location location;
                    settings = (Settings)this.settingsXmlFactory.read(XmlReaderRequest.builder().inputStream(is2).location(settingsSource.getLocation()).strict(false).build());
                    Throwable throwable = e.getCause();
                    if (throwable instanceof XMLStreamException) {
                        XMLStreamException xe = (XMLStreamException)throwable;
                        location = xe.getLocation();
                    } else {
                        location = null;
                    }
                    Location loc = location;
                    problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), loc != null ? loc.getLineNumber() : -1, loc != null ? loc.getColumnNumber() : -1, (Exception)((Object)e), e.getMessage(), BuilderProblem.Severity.WARNING));
                }
            }
        }
        catch (XmlReaderException e) {
            Location location;
            Throwable throwable = e.getCause();
            if (throwable instanceof XMLStreamException) {
                XMLStreamException xe = (XMLStreamException)throwable;
                location = xe.getLocation();
            } else {
                location = null;
            }
            Location loc = location;
            problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), loc != null ? loc.getLineNumber() : -1, loc != null ? loc.getColumnNumber() : -1, (Exception)((Object)e), "Non-parseable settings " + settingsSource.getLocation() + ": " + e.getMessage(), BuilderProblem.Severity.FATAL));
            return Settings.newInstance();
        }
        catch (IOException e) {
            problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), -1, -1, e, "Non-readable settings " + settingsSource.getLocation() + ": " + e.getMessage(), BuilderProblem.Severity.FATAL));
            return Settings.newInstance();
        }
        settings = this.interpolate(settings, request, problems);
        settings = this.decrypt(settingsSource, settings, request, problems);
        this.settingsValidator.validate(settings, isProjectSettings, problems);
        if (isProjectSettings) {
            settings = Settings.newBuilder((Settings)settings, (boolean)true).localRepository(null).interactiveMode(false).offline(false).proxies(List.of()).usePluginRegistry(false).servers(settings.getServers().stream().map(s -> Server.newBuilder((Server)s, (boolean)true).username(null).passphrase(null).privateKey(null).password(null).filePermissions(null).directoryPermissions(null).build()).toList()).build();
        }
        return settings;
    }

    private Settings interpolate(Settings settings, SettingsBuilderRequest request, List<BuilderProblem> problems) {
        Function src;
        if (request.getInterpolationSource().isPresent()) {
            src = (Function)request.getInterpolationSource().get();
        } else {
            Map userProperties = request.getSession().getUserProperties();
            Map systemProperties = request.getSession().getSystemProperties();
            Function[] functionArray = new Function[2];
            functionArray[0] = userProperties::get;
            functionArray[1] = systemProperties::get;
            src = Interpolator.chain((Function[])functionArray);
        }
        return new DefSettingsTransformer(value -> value != null ? this.interpolator.interpolate(value, src) : null).visit(settings);
    }

    private Settings decrypt(Source settingsSource, Settings settings, SettingsBuilderRequest request, List<BuilderProblem> problems) {
        if (this.dispatchers.isEmpty()) {
            return settings;
        }
        DefaultSecDispatcher secDispatcher = new DefaultSecDispatcher(this.dispatchers, this.getSecuritySettings(request.getSession()));
        AtomicInteger preMaven4Passwords = new AtomicInteger(0);
        Function<String, String> decryptFunction = arg_0 -> DefaultSettingsBuilder.lambda$decrypt$2((SecDispatcher)secDispatcher, preMaven4Passwords, problems, settingsSource, arg_0);
        Settings result = new SettingsTransformer(decryptFunction).visit(settings);
        if (preMaven4Passwords.get() > 0) {
            problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), -1, -1, null, "Detected " + preMaven4Passwords.get() + " pre-Maven 4 legacy encrypted password(s) - configure password encryption with the help of mvnenc for increased security.", BuilderProblem.Severity.WARNING));
        }
        return result;
    }

    private Path getSecuritySettings(ProtoSession session) {
        Map properties = session.getUserProperties();
        String settingsSecurity = (String)properties.get("maven.settings.security");
        if (settingsSecurity != null) {
            return Paths.get(settingsSecurity, new String[0]);
        }
        String mavenUserConf = (String)properties.get("maven.user.conf");
        if (mavenUserConf != null) {
            return Paths.get(mavenUserConf, "settings-security4.xml");
        }
        return Paths.get((String)properties.get("user.home"), ".m2", "settings-security4.xml");
    }

    public List<BuilderProblem> validate(Settings settings, boolean isProjectSettings) {
        ArrayList<BuilderProblem> problems = new ArrayList<BuilderProblem>();
        this.settingsValidator.validate(settings, isProjectSettings, problems);
        return problems;
    }

    public Profile convert(org.apache.maven.api.model.Profile profile) {
        return SettingsUtilsV4.convertToSettingsProfile(profile);
    }

    public org.apache.maven.api.model.Profile convert(Profile profile) {
        return SettingsUtilsV4.convertFromSettingsProfile(profile);
    }

    private static /* synthetic */ String lambda$decrypt$2(SecDispatcher secDispatcher, AtomicInteger preMaven4Passwords, List problems, Source settingsSource, String str) {
        if (str != null && !str.isEmpty() && !str.contains("${") && secDispatcher.isAnyEncryptedString(str)) {
            if (secDispatcher.isLegacyEncryptedString(str)) {
                preMaven4Passwords.incrementAndGet();
            }
            try {
                return secDispatcher.decrypt(str);
            }
            catch (Exception e) {
                problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), -1, -1, e, "Could not decrypt password (fix the corrupted password or remove it, if unused) " + str, BuilderProblem.Severity.FATAL));
            }
        }
        return str;
    }

    static class DefaultSettingsBuilderResult
    implements SettingsBuilderResult {
        private final Settings effectiveSettings;
        private final List<BuilderProblem> problems;

        DefaultSettingsBuilderResult(Settings effectiveSettings, List<BuilderProblem> problems) {
            this.effectiveSettings = effectiveSettings;
            this.problems = problems != null ? problems : new ArrayList();
        }

        public Settings getEffectiveSettings() {
            return this.effectiveSettings;
        }

        public List<BuilderProblem> getProblems() {
            return this.problems;
        }
    }

    static class DefSettingsTransformer
    extends SettingsTransformer {
        DefSettingsTransformer(Function<String, String> transformer) {
            super(transformer);
        }

        @Override
        protected Activation.Builder transformActivation_Condition(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            return builder;
        }
    }
}

