/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class PathSelector
implements PathMatcher {
    private static final List<String> DEFAULT_EXCLUDES = List.of("**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/project.pj", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**", "**/.gitignore", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail");
    private static final int MAVEN_SYNTAX_THRESHOLD = 1;
    private static final String DEFAULT_SYNTAX = "glob:";
    private static final String SPECIAL_CHARACTERS = "*?[]{}\\";
    private static final PathMatcher INCLUDES_ALL = path -> true;
    private final String[] includePatterns;
    private final String[] excludePatterns;
    private final PathMatcher[] includes;
    private final PathMatcher[] excludes;
    private final PathMatcher[] dirIncludes;
    private final PathMatcher[] dirExcludes;
    private final Path baseDirectory;

    public PathSelector(Path directory, Collection<String> includes, Collection<String> excludes, boolean useDefaultExcludes) {
        this.includePatterns = PathSelector.normalizePatterns(includes, false);
        this.excludePatterns = PathSelector.normalizePatterns(PathSelector.effectiveExcludes(excludes, this.includePatterns, useDefaultExcludes), true);
        this.baseDirectory = directory;
        FileSystem system = directory.getFileSystem();
        this.includes = PathSelector.matchers(system, this.includePatterns);
        this.excludes = PathSelector.matchers(system, this.excludePatterns);
        this.dirIncludes = PathSelector.matchers(system, PathSelector.directoryPatterns(this.includePatterns, false));
        this.dirExcludes = PathSelector.matchers(system, PathSelector.directoryPatterns(this.excludePatterns, true));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<String> effectiveExcludes(Collection<String> excludes, String[] includes, boolean useDefaultExcludes) {
        if (excludes == null || excludes.isEmpty()) {
            if (!useDefaultExcludes) return List.of();
            excludes = new ArrayList<String>(DEFAULT_EXCLUDES);
        } else {
            excludes = new ArrayList<String>(excludes);
            if (useDefaultExcludes) {
                excludes.addAll(DEFAULT_EXCLUDES);
            }
        }
        String[] prefixes = new String[includes.length];
        String[] suffixes = new String[includes.length];
        for (int i = 0; i < includes.length; ++i) {
            String include = includes[i];
            if (!include.startsWith(DEFAULT_SYNTAX)) {
                return excludes;
            }
            include = include.substring(DEFAULT_SYNTAX.length());
            prefixes[i] = PathSelector.prefixOrSuffix(include, false);
            suffixes[i] = PathSelector.prefixOrSuffix(include, true);
        }
        prefixes = PathSelector.sortByLength(prefixes, false);
        suffixes = PathSelector.sortByLength(suffixes, true);
        Iterator<String> it = excludes.iterator();
        while (it.hasNext()) {
            String exclude = it.next();
            int s = exclude.indexOf(58);
            if (s > 1 && !exclude.startsWith(DEFAULT_SYNTAX) || !PathSelector.cannotMatch(exclude, prefixes, false) && !PathSelector.cannotMatch(exclude, suffixes, true)) continue;
            it.remove();
        }
        return excludes;
    }

    private static String prefixOrSuffix(String include, boolean suffix) {
        int s = suffix ? -1 : include.length();
        int i = SPECIAL_CHARACTERS.length();
        while (--i >= 0) {
            char c = SPECIAL_CHARACTERS.charAt(i);
            if (suffix) {
                s = Math.max(s, include.lastIndexOf(c));
                continue;
            }
            int p = include.indexOf(c);
            if (p < 0 || p >= s) continue;
            s = p;
        }
        return suffix ? include.substring(s + 1) : include.substring(0, s);
    }

    private static boolean cannotMatch(String exclude, String[] fragments, boolean suffix) {
        exclude = PathSelector.prefixOrSuffix(exclude, suffix);
        for (String fragment : fragments) {
            int fg = fragment.length();
            int ex = exclude.length();
            int length = Math.min(fg, ex);
            if (suffix) {
                fg -= length;
                ex -= length;
            } else {
                fg = 0;
                ex = 0;
            }
            if (!exclude.regionMatches(ex, fragment, fg, length)) continue;
            return false;
        }
        return true;
    }

    private static String[] sortByLength(String[] fragments, boolean suffix) {
        Arrays.sort(fragments, (s1, s2) -> s1.length() - s2.length());
        int count = 0;
        block0: for (String fragment : fragments) {
            int i = count;
            while (--i >= 0) {
                String base = fragments[i];
                if (!(suffix ? fragment.endsWith(base) : fragment.startsWith(base))) continue;
                continue block0;
            }
            fragments[count++] = fragment;
        }
        return fragments.length == count ? fragments : Arrays.copyOf(fragments, count);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] normalizePatterns(Collection<String> patterns, boolean excludes) {
        if (patterns == null || patterns.isEmpty()) {
            return new String[0];
        }
        LinkedHashSet<String> normalized = new LinkedHashSet<String>(patterns.size());
        for (String string : patterns) {
            if (string == null || string.isEmpty()) continue;
            if (string.indexOf(58) <= 1) {
                void var4_10;
                void var4_8;
                String string2 = string.replace(File.separatorChar, '/');
                if (string2.endsWith("/")) {
                    String string3 = string2 + "**";
                }
                while (var4_8.endsWith("/**/**")) {
                    String string4 = var4_8.substring(0, var4_8.length() - 3);
                }
                while (var4_10.startsWith("**/**/")) {
                    String string5 = var4_10.substring(3);
                }
                String string7 = var4_10.replace("/**/**/", "/**/");
                string7 = string7.replace("\\", "\\\\").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}");
                normalized.add(DEFAULT_SYNTAX + string7);
                PathSelector.addPatternsWithOneDirRemoved(normalized, string7, 0);
                continue;
            }
            normalized.add(string);
        }
        return PathSelector.simplify(normalized, excludes);
    }

    private static void addPatternsWithOneDirRemoved(Set<String> patterns, String pattern, int end) {
        int start;
        int length = pattern.length();
        while ((start = pattern.indexOf("**", end)) >= 0) {
            end = start + 2;
            if (end < length) {
                if (pattern.charAt(end) != '/') continue;
                if (start == 0) {
                    ++end;
                }
            }
            if (start > 0 && pattern.charAt(--start) != '/') continue;
            String reduced = pattern.substring(0, start) + pattern.substring(end);
            patterns.add(DEFAULT_SYNTAX + reduced);
            PathSelector.addPatternsWithOneDirRemoved(patterns, reduced, start);
        }
    }

    private static String[] simplify(Set<String> patterns, boolean excludes) {
        if (patterns.remove("**")) {
            patterns.clear();
            if (excludes) {
                patterns.add("**");
            }
        }
        return (String[])patterns.toArray(String[]::new);
    }

    private static String[] directoryPatterns(String[] patterns, boolean excludes) {
        LinkedHashSet<String> directories = new LinkedHashSet<String>(patterns.length);
        for (String pattern : patterns) {
            if (!pattern.startsWith(DEFAULT_SYNTAX)) continue;
            if (excludes) {
                if (!pattern.endsWith("/**")) continue;
                directories.add(pattern.substring(0, pattern.length() - 3));
                continue;
            }
            int s = pattern.indexOf(58);
            if (!pattern.regionMatches(++s, "**/", 0, 3)) continue;
            if ((s = pattern.indexOf(47, s + 3)) < 0) {
                return new String[0];
            }
            directories.add(pattern.substring(0, s));
        }
        return PathSelector.simplify(directories, excludes);
    }

    private static PathMatcher[] matchers(FileSystem fs, String[] patterns) {
        PathMatcher[] matchers = new PathMatcher[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            matchers[i] = fs.getPathMatcher(patterns[i]);
        }
        return matchers;
    }

    public PathMatcher simplify() {
        if (this.excludes.length == 0) {
            switch (this.includes.length) {
                case 0: {
                    return INCLUDES_ALL;
                }
                case 1: {
                    return this.includes[0];
                }
            }
        }
        return this;
    }

    @Override
    public boolean matches(Path path) {
        path = this.baseDirectory.relativize(path);
        return !(this.includes.length != 0 && !PathSelector.isMatched(path, this.includes) || this.excludes.length != 0 && PathSelector.isMatched(path, this.excludes));
    }

    private static boolean isMatched(Path path, PathMatcher[] matchers) {
        for (PathMatcher matcher : matchers) {
            if (!matcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    public boolean couldHoldSelected(Path directory) {
        if (this.baseDirectory.equals(directory)) {
            return true;
        }
        directory = this.baseDirectory.relativize(directory);
        return !(this.dirIncludes.length != 0 && !PathSelector.isMatched(directory, this.dirIncludes) || this.dirExcludes.length != 0 && PathSelector.isMatched(directory, this.dirExcludes));
    }

    private static void append(StringBuilder buffer, String label, String[] patterns) {
        buffer.append(label).append(": [");
        if (patterns != null) {
            for (int i = 0; i < patterns.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(patterns[i]);
            }
        }
        buffer.append(']');
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        PathSelector.append(buffer, "includes", this.includePatterns);
        PathSelector.append(buffer.append(", "), "excludes", this.excludePatterns);
        return buffer.toString();
    }
}

