/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jline;

import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.jline.FastTerminal;
import org.apache.maven.jline.JLineMessageBuilderFactory;
import org.jline.jansi.AnsiConsole;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class MessageUtils {
    static Terminal terminal;
    static LineReader reader;
    static MessageBuilderFactory messageBuilderFactory;
    static boolean colorEnabled;
    static Thread shutdownHook;
    static final Object STARTUP_SHUTDOWN_MONITOR;

    public static void systemInstall(Terminal terminal) {
        MessageUtils.terminal = terminal;
        reader = MessageUtils.createReader(terminal);
    }

    public static void systemInstall() {
        MessageUtils.terminal = new FastTerminal(() -> TerminalBuilder.builder().name("Maven").dumb(true).build(), terminal -> {
            reader = MessageUtils.createReader(terminal);
            AnsiConsole.setTerminal((Terminal)terminal);
            AnsiConsole.systemInstall();
        });
    }

    private static LineReader createReader(Terminal terminal) {
        return LineReaderBuilder.builder().terminal(terminal).build();
    }

    public static void registerShutdownHook() {
        if (shutdownHook == null) {
            shutdownHook = new Thread(() -> {
                Object object = STARTUP_SHUTDOWN_MONITOR;
                synchronized (object) {
                    MessageUtils.doSystemUninstall();
                }
            });
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    public static void systemUninstall() {
        MessageUtils.doSystemUninstall();
        if (shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static void doSystemUninstall() {
        try {
            AnsiConsole.systemUninstall();
        }
        finally {
            terminal = null;
        }
    }

    public static void setColorEnabled(boolean enabled) {
        colorEnabled = enabled;
    }

    public static boolean isColorEnabled() {
        return colorEnabled && terminal != null;
    }

    public static int getTerminalWidth() {
        return terminal != null ? terminal.getWidth() : -1;
    }

    public static MessageBuilder builder() {
        return messageBuilderFactory.builder();
    }

    public static Terminal getTerminal() {
        return terminal;
    }

    static {
        messageBuilderFactory = new JLineMessageBuilderFactory();
        colorEnabled = true;
        STARTUP_SHUTDOWN_MONITOR = new Object();
    }
}

