/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.jxr.util.StringEntry;

public class SimpleWordTokenizer {
    private static final Pattern NONBREAKERS = Pattern.compile("([^()\\[ {}]+)");
    private static final char[] BREAKERS = new char[]{'(', ')', '[', ' ', '{', '}'};

    public static List<StringEntry> tokenize(String line) {
        int start = SimpleWordTokenizer.getStart(line);
        if (line == null || line.length() == 0 || start == -1) {
            return Collections.emptyList();
        }
        return SimpleWordTokenizer.tokenize(line, start);
    }

    public static List<StringEntry> tokenize(String line, String find) {
        ArrayList<StringEntry> foundTokens = new ArrayList<StringEntry>();
        for (StringEntry se : SimpleWordTokenizer.tokenize(line)) {
            if (!se.toString().equals(find)) continue;
            foundTokens.add(se);
        }
        return foundTokens;
    }

    private static List<StringEntry> tokenize(String line, int start) {
        Matcher matcher = NONBREAKERS.matcher(line.substring(start));
        ArrayList<StringEntry> words = new ArrayList<StringEntry>();
        while (matcher.find()) {
            StringEntry entry = new StringEntry(matcher.group(1), matcher.start() + start);
            words.add(entry);
        }
        return words;
    }

    private static int getStart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (SimpleWordTokenizer.isBreaker(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBreaker(char c) {
        for (int i = 0; i < BREAKERS.length; ++i) {
            if (BREAKERS[i] != c) continue;
            return true;
        }
        return false;
    }
}

